/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense;

import boofcv.alg.feature.dense.BaseDenseHog;
import boofcv.alg.feature.describe.DescribeSiftCommon;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;
import org.ddogleg.stats.UtilGaussian;

public class DescribeDenseHogAlg<Input extends ImageBase<Input>>
extends BaseDenseHog<Input> {
    protected GrayF32 orientation = new GrayF32(1, 1);
    protected GrayF64 magnitude = new GrayF64(1, 1);
    double[] histogram;
    double[] weights;

    public DescribeDenseHogAlg(int orientationBins, int pixelsPerCell, int cellsPerBlockX, int cellsPerBlockY, int stepBlock, ImageType<Input> imageType) {
        super(orientationBins, pixelsPerCell, cellsPerBlockX, cellsPerBlockY, stepBlock, imageType);
        this.computeWeightBlockPixels();
    }

    protected void computeWeightBlockPixels() {
        int i;
        int rows = this.cellsPerBlockY * this.pixelsPerCell;
        int cols = this.cellsPerBlockX * this.pixelsPerCell;
        this.weights = new double[rows * cols];
        double offsetRow = 0.0;
        double offsetCol = 0.0;
        int radiusRow = rows / 2;
        int radiusCol = cols / 2;
        if (rows % 2 == 0) {
            offsetRow = 0.5;
        }
        if (cols % 2 == 0) {
            offsetCol = 0.5;
        }
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            double drow = (double)(row - radiusRow) + offsetRow;
            double pdfRow = UtilGaussian.computePDF((double)0.0, (double)radiusRow, (double)drow);
            for (int col = 0; col < cols; ++col) {
                double dcol = (double)(col - radiusCol) + offsetCol;
                double pdfCol = UtilGaussian.computePDF((double)0.0, (double)radiusCol, (double)dcol);
                this.weights[index++] = pdfCol * pdfRow;
            }
        }
        double max = 0.0;
        for (i = 0; i < this.weights.length; ++i) {
            if (!(this.weights[i] > max)) continue;
            max = this.weights[i];
        }
        i = 0;
        while (i < this.weights.length) {
            int n = i++;
            this.weights[n] = this.weights[n] / max;
        }
    }

    @Override
    public void setInput(Input input) {
        super.setInput(input);
        this.orientation.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.magnitude.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.computePixelFeatures();
    }

    private void computePixelFeatures() {
        for (int y = 0; y < this.derivX.height; ++y) {
            int pixelIndex;
            int endIndex = pixelIndex + this.derivX.width;
            for (pixelIndex = y * this.derivX.width; pixelIndex < endIndex; ++pixelIndex) {
                float dx = this.derivX.data[pixelIndex];
                float dy = this.derivY.data[pixelIndex];
                this.orientation.data[pixelIndex] = UtilAngle.atanSafe((float)dy, (float)dx) + GrlConstants.F_PId2;
                this.magnitude.data[pixelIndex] = Math.sqrt(dx * dx + dy * dy);
            }
        }
    }

    @Override
    public void process() {
        this.locations.reset();
        this.descriptions.reset();
        int stepBlockPixelsX = this.pixelsPerCell * this.stepBlock;
        int stepBlockPixelsY = this.pixelsPerCell * this.stepBlock;
        int maxY = this.derivX.height - this.pixelsPerCell * this.cellsPerBlockY + 1;
        int maxX = this.derivX.width - this.pixelsPerCell * this.cellsPerBlockX + 1;
        for (int y = 0; y < maxY; y += stepBlockPixelsY) {
            for (int x = 0; x < maxX; x += stepBlockPixelsX) {
                TupleDesc_F64 d = (TupleDesc_F64)this.descriptions.grow();
                Arrays.fill(d.value, 0.0);
                this.histogram = d.value;
                for (int cellRow = 0; cellRow < this.cellsPerBlockY; ++cellRow) {
                    int blockPixelRow = cellRow * this.pixelsPerCell;
                    for (int cellCol = 0; cellCol < this.cellsPerBlockX; ++cellCol) {
                        int blockPixelCol = cellCol * this.pixelsPerCell;
                        this.computeCellHistogram(x + blockPixelCol, y + blockPixelRow, cellCol, cellRow);
                    }
                }
                DescribeSiftCommon.normalizeDescriptor(d, 0.2);
                ((Point2D_I32)this.locations.grow()).set(x, y);
            }
        }
    }

    void computeCellHistogram(int pixelX0, int pixelY0, int cellX, int cellY) {
        float angleBinSize = GrlConstants.F_PI / (float)this.orientationBins;
        for (int i = 0; i < this.pixelsPerCell; ++i) {
            double spatialWeightY2;
            double spatialWeightY0;
            double spatialWeightY1;
            int indexPixel = (pixelY0 + i) * this.derivX.stride + pixelX0;
            int indexBlock = (cellY * this.pixelsPerCell + i) * this.pixelsPerCell * this.cellsPerBlockX + cellX * this.pixelsPerCell;
            if (i <= this.pixelsPerCell / 2) {
                spatialWeightY1 = ((double)i + (double)this.pixelsPerCell / 2.0) / (double)this.pixelsPerCell;
                spatialWeightY0 = 1.0 - spatialWeightY1;
                spatialWeightY2 = 0.0;
            } else {
                spatialWeightY0 = 0.0;
                spatialWeightY2 = ((double)i - (double)this.pixelsPerCell / 2.0) / (double)this.pixelsPerCell;
                spatialWeightY1 = 1.0 - spatialWeightY2;
            }
            int j = 0;
            while (j < this.pixelsPerCell) {
                double spatialWeightX2;
                double spatialWeightX0;
                double spatialWeightX1;
                if (j <= this.pixelsPerCell / 2) {
                    spatialWeightX1 = ((double)j + (double)this.pixelsPerCell / 2.0) / (double)this.pixelsPerCell;
                    spatialWeightX0 = 1.0 - spatialWeightX1;
                    spatialWeightX2 = 0.0;
                } else {
                    spatialWeightX0 = 0.0;
                    spatialWeightX2 = ((double)j - (double)this.pixelsPerCell / 2.0) / (double)this.pixelsPerCell;
                    spatialWeightX1 = 1.0 - spatialWeightX2;
                }
                float angle = this.orientation.data[indexPixel];
                double magnitude = this.magnitude.data[indexPixel];
                float findex0 = angle / angleBinSize;
                int index0 = (int)findex0;
                double oriWeight1 = findex0 - (float)index0;
                int index1 = ((index0 %= this.orientationBins) + 1) % this.orientationBins;
                this.addToHistogram(cellX - 1, cellY - 1, index0, (1.0 - oriWeight1) * (magnitude *= this.weights[indexBlock]) * spatialWeightX0 * spatialWeightY0);
                this.addToHistogram(cellX - 1, cellY - 1, index1, oriWeight1 * magnitude * spatialWeightX0 * spatialWeightY0);
                this.addToHistogram(cellX, cellY - 1, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX1 * spatialWeightY0);
                this.addToHistogram(cellX, cellY - 1, index1, oriWeight1 * magnitude * spatialWeightX1 * spatialWeightY0);
                this.addToHistogram(cellX + 1, cellY - 1, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX2 * spatialWeightY0);
                this.addToHistogram(cellX + 1, cellY - 1, index1, oriWeight1 * magnitude * spatialWeightX2 * spatialWeightY0);
                this.addToHistogram(cellX - 1, cellY, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX0 * spatialWeightY1);
                this.addToHistogram(cellX - 1, cellY, index1, oriWeight1 * magnitude * spatialWeightX0 * spatialWeightY1);
                this.addToHistogram(cellX, cellY, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX1 * spatialWeightY1);
                this.addToHistogram(cellX, cellY, index1, oriWeight1 * magnitude * spatialWeightX1 * spatialWeightY1);
                this.addToHistogram(cellX + 1, cellY, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX2 * spatialWeightY1);
                this.addToHistogram(cellX + 1, cellY, index1, oriWeight1 * magnitude * spatialWeightX2 * spatialWeightY1);
                this.addToHistogram(cellX - 1, cellY + 1, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX0 * spatialWeightY2);
                this.addToHistogram(cellX - 1, cellY + 1, index1, oriWeight1 * magnitude * spatialWeightX0 * spatialWeightY2);
                this.addToHistogram(cellX, cellY + 1, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX1 * spatialWeightY2);
                this.addToHistogram(cellX, cellY + 1, index1, oriWeight1 * magnitude * spatialWeightX1 * spatialWeightY2);
                this.addToHistogram(cellX + 1, cellY + 1, index0, (1.0 - oriWeight1) * magnitude * spatialWeightX2 * spatialWeightY2);
                this.addToHistogram(cellX + 1, cellY + 1, index1, oriWeight1 * magnitude * spatialWeightX2 * spatialWeightY2);
                ++j;
                ++indexPixel;
                ++indexBlock;
            }
        }
    }

    void addToHistogram(int cellX, int cellY, int orientationIndex, double magnitude) {
        int index;
        if (cellX < 0 || cellX >= this.cellsPerBlockX) {
            return;
        }
        if (cellY < 0 || cellY >= this.cellsPerBlockY) {
            return;
        }
        int n = index = (cellY * this.cellsPerBlockX + cellX) * this.orientationBins + orientationIndex;
        this.histogram[n] = this.histogram[n] + magnitude;
    }
}

