/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.abst.filter.binary.BinaryContourFinderLinearExternal;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.CircularIndex;
import boofcv.struct.ConnectRule;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPoint2D_I32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectChessboardCorners<T extends ImageGray<T>, D extends ImageGray<D>> {
    public static final int GRAY_LEVELS = 300;
    int shiRadius;
    int shiWidth;
    double cornerIntensityThreshold = 1.0;
    GradientCornerIntensity<D> cornerIntensity;
    GrayF32 intensity = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    InputToBinary<GrayF32> inputToBinary;
    BinaryContourFinderLinearExternal contourFinder = new BinaryContourFinderLinearExternal();
    FastQueue<ChessboardCorner> corners = new FastQueue(ChessboardCorner.class, true);
    FastQueue<Point2D_I32> contour = new FastQueue(Point2D_I32.class, true);
    ImageGradient<T, D> gradient;
    D derivX;
    D derivY;
    InterpolatePixelS<D> interpX;
    InterpolatePixelS<D> interpY;
    ImageBorder<T> borderImg;
    ImageLineIntegral integral = new ImageLineIntegral();
    InterpolatePixelS<GrayF32> intensityInterp = FactoryInterpolation.bilinearPixelS(GrayF32.class, (BorderType)BorderType.ZERO);
    public boolean useMeanShift = true;
    private final int numLines = 16;
    private final double[] lines = new double[16];
    private final double[] smoothed = new double[16];
    private final Kernel1D_F64 kernelSmooth = (Kernel1D_F64)FactoryKernelGaussian.gaussian((int)1, (boolean)true, (int)64, (double)-1.0, (int)4);
    Class<T> imageType;
    Class<D> derivType;

    public DetectChessboardCorners(Class<T> imageType) {
        this.imageType = imageType;
        this.derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.setKernelRadius(1);
        this.setThresholding((InputToBinary<GrayF32>)FactoryThresholdBinary.globalOtsu((double)0.0, (double)300.0, (double)1.0, (boolean)false, GrayF32.class));
        this.contourFinder.setConnectRule(ConnectRule.EIGHT);
        this.gradient = FactoryDerivative.prewitt(imageType, this.derivType);
        this.derivX = GeneralizedImageOps.createSingleBand(this.derivType, (int)1, (int)1);
        this.derivY = GeneralizedImageOps.createSingleBand(this.derivType, (int)1, (int)1);
        this.interpX = FactoryInterpolation.bilinearPixelS(this.derivType, (BorderType)BorderType.ZERO);
        this.interpY = FactoryInterpolation.bilinearPixelS(this.derivType, (BorderType)BorderType.ZERO);
        this.borderImg = FactoryImageBorder.single(imageType, (BorderType)BorderType.ZERO);
        this.borderImg.setImage((ImageBase)GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1));
        this.integral.setImage(FactoryGImageGray.wrap(this.borderImg));
    }

    public void process(T input) {
        this.borderImg.setImage(input);
        this.gradient.process(input, this.derivX, this.derivY);
        this.interpX.setImage(this.derivX);
        this.interpY.setImage(this.derivY);
        this.cornerIntensity.process(this.derivX, this.derivY, this.intensity);
        this.intensityInterp.setImage((ImageBase)this.intensity);
        float featmax = ImageStatistics.max((GrayF32)this.intensity);
        PixelMath.multiply((GrayF32)this.intensity, (float)(300.0f / featmax), (GrayF32)this.intensity);
        this.inputToBinary.process((ImageBase)this.intensity, this.binary);
        this.contourFinder.process(this.binary);
        this.corners.reset();
        List packed = this.contourFinder.getContours();
        for (int i = 0; i < packed.size(); ++i) {
            this.contourFinder.loadContour(i, this.contour);
            ChessboardCorner c = (ChessboardCorner)((Object)this.corners.grow());
            UtilPoint2D_I32.mean((List)this.contour.toList(), (Point2D_F64)c);
            c.x += 0.5;
            c.y += 0.5;
            this.computeFeatures(c.x, c.y, c);
            if (c.intensity < this.cornerIntensityThreshold) {
                this.corners.removeTail();
                continue;
            }
            if (!this.useMeanShift) continue;
            this.meanShiftLocation(c);
            this.computeFeatures(c.x, c.y, c);
        }
    }

    private void computeFeatures(double cx, double cy, ChessboardCorner corner) {
        double r = this.shiRadius + 2;
        double sumDifference = 0.0;
        for (int i = 0; i < 16; ++i) {
            double angle = Math.PI * (double)i / 16.0 - 1.5707963267948966;
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            double x0 = cx - r * c;
            double y0 = cy - r * s;
            double x1 = cx + r * c;
            double y1 = cy + r * s;
            double left = this.integral.compute(cx, cy, x0, y0);
            double right = this.integral.compute(cx, cy, x1, y1);
            sumDifference += Math.abs(left - right);
            this.lines[i] = left + right;
        }
        int r_smooth = this.kernelSmooth.getRadius();
        int w_smooth = this.kernelSmooth.getWidth();
        for (int i = 0; i < 16; ++i) {
            int start = CircularIndex.addOffset((int)i, (int)(-r_smooth), (int)16);
            double sum = 0.0;
            for (int j = 0; j < w_smooth; ++j) {
                int index = CircularIndex.addOffset((int)start, (int)j, (int)16);
                sum += this.lines[index] * this.kernelSmooth.data[j];
            }
            this.smoothed[i] = sum;
        }
        int indexMin = 0;
        double valueMin = Double.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            if (!(this.smoothed[i] < valueMin)) continue;
            valueMin = this.smoothed[i];
            indexMin = i;
        }
        double value0 = this.smoothed[CircularIndex.addOffset((int)indexMin, (int)-1, (int)16)];
        double value2 = this.smoothed[CircularIndex.addOffset((int)indexMin, (int)1, (int)16)];
        double adjustedIndex = (double)indexMin + FastHessianFeatureDetector.polyPeak(value0, valueMin, value2);
        corner.orientation = Math.PI * adjustedIndex / 16.0 - 1.5707963267948966;
        double intensity = 0.0;
        for (int i = 0; i < 8; ++i) {
            int idx0 = CircularIndex.addOffset((int)indexMin, (int)(i - 4), (int)16);
            int idx1 = CircularIndex.addOffset((int)idx0, (int)8, (int)16);
            intensity += this.smoothed[idx1] - this.smoothed[idx0];
        }
        corner.intensity = intensity / (r * 2.0 + 1.0 + 8.0);
        corner.intensity /= sumDifference / 16.0;
    }

    public void meanShiftLocation(ChessboardCorner c) {
        float meanX = (float)c.x;
        float meanY = (float)c.y;
        int radius = this.shiRadius * 2;
        for (int iteration = 0; iteration < 5; ++iteration) {
            float adjX = 0.0f;
            float adjY = 0.0f;
            float total = 0.0f;
            for (int y = -radius; y < radius; ++y) {
                float yy = y;
                for (int x = -radius; x < radius; ++x) {
                    float xx = x;
                    float v = this.intensityInterp.get(meanX + xx, meanY + yy);
                    adjX = (float)((double)adjX + ((double)xx + 0.5) * (double)v);
                    adjY = (float)((double)adjY + ((double)yy + 0.5) * (double)v);
                    total += v;
                }
            }
            meanX += adjX / total;
            meanY += adjY / total;
        }
        c.x = meanX;
        c.y = meanY;
    }

    public GrayF32 getIntensity() {
        return this.intensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public FastQueue<ChessboardCorner> getCorners() {
        return this.corners;
    }

    public BinaryContourFinderLinearExternal getContourFinder() {
        return this.contourFinder;
    }

    public void setThresholding(InputToBinary<GrayF32> inputToBinary) {
        this.inputToBinary = inputToBinary;
    }

    public void setKernelRadius(int radius) {
        this.shiRadius = radius;
        this.shiWidth = radius * 2 + 1;
        this.cornerIntensity = FactoryIntensityPointAlg.shiTomasi(radius, false, this.derivType);
        if (radius == 1) {
            this.contourFinder.setMaxContour(1000);
            this.contourFinder.setMinContour(0);
        } else {
            this.contourFinder.setMaxContour((this.shiWidth + 1) * 4 + 4);
            this.contourFinder.setMinContour((this.shiWidth - 1) * 4 - 4);
        }
    }

    public int getKernelRadius() {
        return this.shiRadius;
    }

    public double getCornerIntensityThreshold() {
        return this.cornerIntensityThreshold;
    }

    public void setCornerIntensityThreshold(double cornerIntensityThreshold) {
        this.cornerIntensityThreshold = cornerIntensityThreshold;
    }

    public Class<T> getImageType() {
        return this.imageType;
    }

    public Class<D> getDerivType() {
        return this.derivType;
    }
}

