/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.chess.ChessboardCornerDistance;
import boofcv.alg.feature.detect.chess.DetectChessboardCorners;
import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.FastQueue;

public class DetectChessboardCornersPyramid<T extends ImageGray<T>, D extends ImageGray<D>> {
    int pyramidTopSize = 100;
    List<T> pyramid = new ArrayList<T>();
    DetectChessboardCorners<T, D> detector;
    FastQueue<PyramidLevel> featureLevels = new FastQueue(PyramidLevel.class, () -> new PyramidLevel());
    FastQueue<ChessboardCorner> corners = new FastQueue(ChessboardCorner.class, true);
    NearestNeighbor<ChessboardCorner> nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new ChessboardCornerDistance());
    NearestNeighbor.Search<ChessboardCorner> nnSearch = this.nn.createSearch();
    FastQueue<NnData<ChessboardCorner>> nnResults = new FastQueue(NnData.class, true);

    public DetectChessboardCornersPyramid(DetectChessboardCorners<T, D> detector) {
        this.detector = detector;
    }

    public DetectChessboardCornersPyramid(Class<T> imageType) {
        this(new DetectChessboardCorners(imageType));
    }

    public void process(T input) {
        int levelIdx;
        this.constructPyramid(input);
        this.corners.reset();
        double scale = Math.pow(2.0, this.pyramid.size() - 1);
        for (int level = this.pyramid.size() - 1; level >= 0; --level) {
            this.detector.process((ImageGray)this.pyramid.get(level));
            PyramidLevel featsLevel = (PyramidLevel)this.featureLevels.get(level);
            FastQueue<ChessboardCorner> corners = this.detector.getCorners();
            featsLevel.corners.reset();
            for (int i = 0; i < corners.size; ++i) {
                ChessboardCorner cf = (ChessboardCorner)((Object)corners.get(i));
                double x = cf.x * scale;
                double y = cf.y * scale;
                ChessboardCorner cl = (ChessboardCorner)((Object)featsLevel.corners.grow());
                cl.first = true;
                cl.set(x, y, cf.orientation, cf.intensity);
            }
            scale /= 2.0;
        }
        for (levelIdx = 0; levelIdx < this.pyramid.size(); ++levelIdx) {
            PyramidLevel level0 = (PyramidLevel)this.featureLevels.get(levelIdx);
            for (int nextIdx = levelIdx + 1; nextIdx < this.pyramid.size(); ++nextIdx) {
                PyramidLevel level1 = (PyramidLevel)this.featureLevels.get(nextIdx);
                this.markSeenAsFalse(level0.corners, level1.corners);
            }
        }
        for (levelIdx = 0; levelIdx < this.pyramid.size(); ++levelIdx) {
            PyramidLevel level = (PyramidLevel)this.featureLevels.get(levelIdx);
            for (int i = 0; i < level.corners.size; ++i) {
                ChessboardCorner c = (ChessboardCorner)((Object)level.corners.get(i));
                if (!c.first) continue;
                ((ChessboardCorner)((Object)this.corners.grow())).set(c);
            }
        }
    }

    void markSeenAsFalse(FastQueue<ChessboardCorner> corners0, FastQueue<ChessboardCorner> corners1) {
        this.nn.setPoints(corners1.toList(), false);
        int radius = this.detector.shiRadius * 2 + 2;
        for (int i = 0; i < corners0.size; ++i) {
            ChessboardCorner c1;
            int j;
            ChessboardCorner c0 = (ChessboardCorner)((Object)corners0.get(i));
            if (!c0.first) continue;
            this.nnSearch.findNearest((Object)c0, (double)radius, 5, this.nnResults);
            double maxIntensity = 0.0;
            for (j = 0; j < this.nnResults.size; ++j) {
                c1 = (ChessboardCorner)((Object)((NnData)this.nnResults.get((int)j)).point);
                maxIntensity = Math.max(c1.intensity, maxIntensity);
            }
            if (maxIntensity < c0.intensity * 1.5) {
                for (j = 0; j < this.nnResults.size; ++j) {
                    c1 = (ChessboardCorner)((Object)((NnData)this.nnResults.get((int)j)).point);
                    c1.first = false;
                }
                continue;
            }
            c0.first = false;
        }
    }

    void constructPyramid(T input) {
        if (this.pyramid.size() == 0) {
            this.pyramid.add(input);
        } else {
            this.pyramid.set(0, input);
        }
        int pyramidTopSize = this.pyramidTopSize;
        if (pyramidTopSize != 0 && pyramidTopSize < (1 + 2 * this.detector.getKernelRadius()) * 5) {
            pyramidTopSize = (1 + 2 * this.detector.getKernelRadius()) * 5;
        }
        int levelIndex = 1;
        int divisor = 2;
        while (true) {
            ImageGray level;
            int width = ((ImageGray)input).width / divisor;
            int height = ((ImageGray)input).height / divisor;
            if (pyramidTopSize == 0 || width < pyramidTopSize || height < pyramidTopSize) break;
            if (this.pyramid.size() <= levelIndex) {
                level = GeneralizedImageOps.createSingleBand(this.detector.imageType, (int)width, (int)height);
                this.pyramid.add(level);
            } else {
                level = (ImageGray)this.pyramid.get(levelIndex);
                level.reshape(width, height);
            }
            AverageDownSampleOps.down((ImageGray)((ImageGray)this.pyramid.get(levelIndex - 1)), (int)2, (ImageGray)level);
            divisor *= 2;
            ++levelIndex;
        }
        while (this.pyramid.size() > levelIndex) {
            this.pyramid.remove(this.pyramid.size() - 1);
        }
        this.featureLevels.resize(this.pyramid.size());
    }

    public DetectChessboardCorners<T, D> getDetector() {
        return this.detector;
    }

    public FastQueue<ChessboardCorner> getCorners() {
        return this.corners;
    }

    public int getPyramidTopSize() {
        return this.pyramidTopSize;
    }

    public void setPyramidTopSize(int pyramidTopSize) {
        this.pyramidTopSize = pyramidTopSize;
    }

    private static class PyramidLevel {
        FastQueue<ChessboardCorner> corners = new FastQueue(ChessboardCorner.class, true);

        private PyramidLevel() {
        }
    }
}

