/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FeatureIntensity;
import boofcv.alg.feature.detect.intensity.impl.FastCornerInterface;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class FastCornerDetector<T extends ImageGray<T>>
implements FeatureIntensity<T> {
    protected static final int radius = 3;
    protected int[] offsets;
    private int stride = 0;
    private QueueCorner candidatesLow = new QueueCorner(10);
    private QueueCorner candidatesHigh = new QueueCorner(10);
    protected T image;
    protected FastCornerInterface<T> helper;
    protected double maxFeaturesFraction = 1.0;

    public FastCornerDetector(FastCornerInterface<T> helper) {
        this.helper = helper;
    }

    public QueueCorner getCornersLow() {
        return this.candidatesLow;
    }

    public QueueCorner getCornersHigh() {
        return this.candidatesHigh;
    }

    @Override
    public int getRadius() {
        return 3;
    }

    @Override
    public int getIgnoreBorder() {
        return 3;
    }

    public void process(T image, GrayF32 intensity) {
        int maxFeatures = (int)(this.maxFeaturesFraction * (double)((ImageGray)image).width * (double)((ImageGray)image).height);
        this.candidatesLow.reset();
        this.candidatesHigh.reset();
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageGray)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageGray)image).height - 3; ++y) {
            int indexIntensity = intensity.startIndex + y * intensity.stride + 3;
            int index = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride + 3;
            int x = 3;
            while (x < ((ImageGray)image).width - 3) {
                int result = this.helper.checkPixel(index);
                if (result < 0) {
                    intensity.data[indexIntensity] = this.helper.scoreLower(index);
                    this.candidatesLow.add(x, y);
                } else if (result > 0) {
                    intensity.data[indexIntensity] = this.helper.scoreUpper(index);
                    this.candidatesHigh.add(x, y);
                } else {
                    intensity.data[indexIntensity] = 0.0f;
                }
                ++x;
                ++index;
                ++indexIntensity;
            }
            if (this.candidatesLow.size + this.candidatesHigh.size >= maxFeatures) break;
        }
    }

    public void process(T image) {
        int maxFeatures = (int)(this.maxFeaturesFraction * (double)((ImageGray)image).width * (double)((ImageGray)image).height);
        this.candidatesLow.reset();
        this.candidatesHigh.reset();
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageGray)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageGray)image).height - 3; ++y) {
            int index = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride + 3;
            int x = 3;
            while (x < ((ImageGray)image).width - 3) {
                int result = this.helper.checkPixel(index);
                if (result < 0) {
                    this.candidatesLow.add(x, y);
                } else if (result > 0) {
                    this.candidatesHigh.add(x, y);
                }
                ++x;
                ++index;
            }
            if (this.candidatesLow.size + this.candidatesHigh.size >= maxFeatures) break;
        }
    }

    public double getMaxFeaturesFraction() {
        return this.maxFeaturesFraction;
    }

    public void setMaxFeaturesFraction(double maxFeaturesFraction) {
        if (maxFeaturesFraction <= 0.0 || maxFeaturesFraction > 1.0) {
            throw new IllegalArgumentException("0 to 1");
        }
        this.maxFeaturesFraction = maxFeaturesFraction;
    }
}

