/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.extract;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.extract.WrapperNonMaxCandidate;
import boofcv.abst.feature.detect.extract.WrapperNonMaximumBlock;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.alg.feature.detect.extract.NonMaxBlockSearchRelaxed;
import boofcv.alg.feature.detect.extract.NonMaxBlockSearchStrict;
import boofcv.alg.feature.detect.extract.NonMaxBlock_MT;
import boofcv.alg.feature.detect.extract.NonMaxCandidate;
import boofcv.alg.feature.detect.extract.NonMaxCandidate_MT;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.detect.extract.BOverrideFactoryFeatureExtractor;
import boofcv.struct.image.ImageGray;
import javax.annotation.Nullable;

public class FactoryFeatureExtractor {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureDetector<I, D> general(GeneralFeatureIntensity<I, D> intensity, NonMaxSuppression extractor, int maxFeatures) {
        GeneralFeatureDetector<I, D> det = new GeneralFeatureDetector<I, D>(intensity, extractor);
        det.setMaxFeatures(maxFeatures);
        return det;
    }

    public static NonMaxSuppression nonmax(@Nullable ConfigExtract config) {
        if (config == null) {
            config = new ConfigExtract();
        }
        config.checkValidity();
        if (BOverrideFactoryFeatureExtractor.nonmax != null) {
            return BOverrideFactoryFeatureExtractor.nonmax.process(config);
        }
        NonMaxBlock.Search search = config.useStrictRule ? (config.detectMaximums ? (config.detectMinimums ? new NonMaxBlockSearchStrict.MinMax() : new NonMaxBlockSearchStrict.Max()) : new NonMaxBlockSearchStrict.Min()) : (config.detectMaximums ? (config.detectMinimums ? new NonMaxBlockSearchRelaxed.MinMax() : new NonMaxBlockSearchRelaxed.Max()) : new NonMaxBlockSearchRelaxed.Min());
        NonMaxBlock alg = BoofConcurrency.USE_CONCURRENT ? new NonMaxBlock_MT(search) : new NonMaxBlock(search);
        alg.setSearchRadius(config.radius);
        alg.setThresholdMax(config.threshold);
        alg.setThresholdMin(-config.threshold);
        alg.setBorder(config.ignoreBorder);
        return new WrapperNonMaximumBlock(alg);
    }

    public static NonMaxSuppression nonmaxCandidate(@Nullable ConfigExtract config) {
        if (config == null) {
            config = new ConfigExtract();
        }
        config.checkValidity();
        if (BOverrideFactoryFeatureExtractor.nonmaxCandidate != null) {
            return BOverrideFactoryFeatureExtractor.nonmaxCandidate.process(config);
        }
        NonMaxCandidate.Search search = config.useStrictRule ? new NonMaxCandidate.Strict() : new NonMaxCandidate.Relaxed();
        NonMaxCandidate extractor = BoofConcurrency.USE_CONCURRENT ? new NonMaxCandidate_MT(search) : new NonMaxCandidate(search);
        WrapperNonMaxCandidate ret = new WrapperNonMaxCandidate(extractor, false, true);
        ret.setSearchRadius(config.radius);
        ret.setIgnoreBorder(config.ignoreBorder);
        ret.setThresholdMaximum(config.threshold);
        return ret;
    }

    public static NonMaxLimiter nonmaxLimiter(@Nullable ConfigExtract config, int maxFeatures) {
        NonMaxSuppression nonmax = FactoryFeatureExtractor.nonmax(config);
        return new NonMaxLimiter(nonmax, maxFeatures);
    }
}

