/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectEdgeLinesToLines;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.feature.detect.line.DetectLineHoughFootSubimage;
import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.abst.feature.detect.line.HoughBinary_to_DetectLine;
import boofcv.abst.feature.detect.line.HoughGradient_to_DetectLine;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.feature.detect.line.HoughTransformBinary;
import boofcv.alg.feature.detect.line.HoughTransformGradient;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.detect.line.ConfigHoughBinary;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughGradient;
import boofcv.factory.feature.detect.line.ConfigLineRansac;
import boofcv.factory.feature.detect.line.ConfigParamFoot;
import boofcv.factory.feature.detect.line.ConfigParamPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.image.ImageGray;
import javax.annotation.Nullable;

public class FactoryDetectLine {
    public static <I extends ImageGray<I>> DetectLineSegment<I> lineRansac(@Nullable ConfigLineRansac config, Class<I> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        return FactoryDetectLineAlgs.lineRansac(config, imageType, derivType);
    }

    public static <T extends ImageGray<T>> DetectLine<T> houghLineFootSub(@Nullable ConfigHoughFootSubimage config, Class<T> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        DetectLineHoughFootSubimage alg = FactoryDetectLineAlgs.houghFootSub(config, derivType);
        return new DetectEdgeLinesToLines(alg, imageType, derivType);
    }

    public static <T extends ImageGray<T>> DetectLine<T> houghLineFoot(@Nullable ConfigHoughGradient configHough, @Nullable ConfigParamFoot configParam, Class<T> imageType) {
        if (configHough == null) {
            configHough = new ConfigHoughGradient();
        }
        if (configParam == null) {
            configParam = new ConfigParamFoot();
        }
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        HoughTransformGradient hough = FactoryDetectLineAlgs.houghLineFoot(configHough, configParam, derivType);
        HoughGradient_to_DetectLine detector = new HoughGradient_to_DetectLine(hough, imageType);
        detector.setThresholdEdge(configHough.thresholdEdge);
        return detector;
    }

    public static <T extends ImageGray<T>> DetectLine<T> houghLinePolar(@Nullable ConfigHoughGradient configHough, @Nullable ConfigParamPolar configParam, Class<T> imageType) {
        if (configHough == null) {
            configHough = new ConfigHoughGradient();
        }
        if (configParam == null) {
            configParam = new ConfigParamPolar();
        }
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        HoughTransformGradient hough = FactoryDetectLineAlgs.houghLinePolar(configHough, configParam, derivType);
        HoughGradient_to_DetectLine detector = new HoughGradient_to_DetectLine(hough, imageType);
        detector.setThresholdEdge(configHough.thresholdEdge);
        return detector;
    }

    public static <T extends ImageGray<T>> DetectLine<T> houghLinePolar(@Nullable ConfigHoughBinary configHough, @Nullable ConfigParamPolar configParam, @Nullable ConfigThreshold configThreshold, Class<T> imageType) {
        if (configHough == null) {
            configHough = new ConfigHoughBinary();
        }
        if (configParam == null) {
            configParam = new ConfigParamPolar();
        }
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.global((ThresholdType)ThresholdType.GLOBAL_OTSU);
        }
        HoughTransformBinary hough = FactoryDetectLineAlgs.houghLinePolar(configHough, configParam);
        InputToBinary thresholder = FactoryThresholdBinary.threshold((ConfigThreshold)configThreshold, imageType);
        return new HoughBinary_to_DetectLine(hough, thresholder);
    }
}

