/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.template;

import boofcv.alg.feature.detect.template.TemplateCorrelationFFT;
import boofcv.alg.feature.detect.template.TemplateDiffSquared;
import boofcv.alg.feature.detect.template.TemplateIntensityImage;
import boofcv.alg.feature.detect.template.TemplateIntensityImage_MT;
import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.alg.feature.detect.template.TemplateNCC;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.detect.template.TemplateScoreType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryTemplateMatching {
    public static <T extends ImageGray<T>> TemplateMatchingIntensity<T> createIntensity(TemplateScoreType type, Class<T> imageType) {
        TemplateIntensityImage.EvaluatorMethod<GrayU8> method;
        if (type == TemplateScoreType.CORRELATION) {
            if (imageType == GrayF32.class) {
                return new TemplateCorrelationFFT();
            }
            throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
        }
        switch (type) {
            case SUM_DIFF_SQ: {
                if (imageType == GrayU8.class) {
                    method = new TemplateDiffSquared.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateDiffSquared.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case NCC: {
                if (imageType == GrayU8.class) {
                    method = new TemplateNCC.U8();
                    break;
                }
                if (imageType == GrayF32.class) {
                    method = new TemplateNCC.F32();
                    break;
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown");
            }
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            return new TemplateIntensityImage_MT<GrayU8>(method);
        }
        return new TemplateIntensityImage<GrayU8>(method);
    }

    public static <T extends ImageGray<T>> TemplateMatching<T> createMatcher(TemplateScoreType type, Class<T> imageType) {
        TemplateMatchingIntensity<T> intensity = FactoryTemplateMatching.createIntensity(type, imageType);
        return new TemplateMatching<T>(intensity);
    }
}

