/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.segmentation;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights4_F32;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights4_PLF32;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights4_PLU8;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights4_U8;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights8_F32;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights8_PLF32;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights8_PLU8;
import boofcv.alg.segmentation.fh04.impl.FhEdgeWeights8_U8;
import boofcv.alg.segmentation.ms.MergeRegionMeanShift;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.alg.segmentation.ms.SegmentMeanShift;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearch;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearchColor;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearchGray;
import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.alg.segmentation.slic.SegmentSlic_F32;
import boofcv.alg.segmentation.slic.SegmentSlic_PlF32;
import boofcv.alg.segmentation.slic.SegmentSlic_PlU8;
import boofcv.alg.segmentation.slic.SegmentSlic_U8;
import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.segmentation.ConfigFh04;
import boofcv.factory.segmentation.ConfigSegmentMeanShift;
import boofcv.factory.segmentation.ConfigSlic;
import boofcv.struct.ConnectRule;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FactorySegmentationAlg {
    public static <T extends ImageBase<T>> ComputeRegionMeanColor<T> regionMeanColor(ImageType<T> imageType) {
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            switch (imageType.getDataType()) {
                case U8: {
                    return new ComputeRegionMeanColor.U8();
                }
                case F32: {
                    return new ComputeRegionMeanColor.F32();
                }
            }
        } else if (imageType.getFamily() == ImageType.Family.PLANAR) {
            int N = imageType.getNumBands();
            switch (imageType.getDataType()) {
                case U8: {
                    return new ComputeRegionMeanColor.PL_U8(N);
                }
                case F32: {
                    return new ComputeRegionMeanColor.PL_F32(N);
                }
            }
        }
        throw new IllegalArgumentException("Unknown imageType");
    }

    public static <T extends ImageBase<T>> SegmentMeanShift<T> meanShift(@Nullable ConfigSegmentMeanShift config, ImageType<T> imageType) {
        SegmentMeanShiftSearch search;
        InterpolatePixelS interp;
        if (config == null) {
            config = new ConfigSegmentMeanShift();
        }
        int spacialRadius = config.spacialRadius;
        float colorRadius = config.colorRadius;
        int maxIterations = 20;
        float convergenceTol = 0.1f;
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            interp = FactoryInterpolation.bilinearPixelS((Class)imageType.getImageClass(), (BorderType)BorderType.EXTENDED);
            search = new SegmentMeanShiftSearchGray(maxIterations, convergenceTol, interp, spacialRadius, spacialRadius, colorRadius, config.fast);
        } else {
            interp = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
            search = new SegmentMeanShiftSearchColor<T>(maxIterations, convergenceTol, interp, spacialRadius, spacialRadius, colorRadius, config.fast, imageType);
        }
        ComputeRegionMeanColor<T> regionColor = FactorySegmentationAlg.regionMeanColor(imageType);
        MergeRegionMeanShift merge = new MergeRegionMeanShift(spacialRadius / 2 + 1, Math.max(1.0f, colorRadius / 2.0f));
        MergeSmallRegions<T> prune = config.minimumRegionSize >= 2 ? new MergeSmallRegions<T>(config.minimumRegionSize, config.connectRule, regionColor) : null;
        return new SegmentMeanShift(search, merge, prune, config.connectRule);
    }

    public static <T extends ImageBase<T>> FhEdgeWeights<T> weightsFelzenszwalb04(ConnectRule rule, ImageType<T> imageType) {
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            if (rule == ConnectRule.FOUR) {
                switch (imageType.getDataType()) {
                    case U8: {
                        return new FhEdgeWeights4_U8();
                    }
                    case F32: {
                        return new FhEdgeWeights4_F32();
                    }
                }
            } else if (rule == ConnectRule.EIGHT) {
                switch (imageType.getDataType()) {
                    case U8: {
                        return new FhEdgeWeights8_U8();
                    }
                    case F32: {
                        return new FhEdgeWeights8_F32();
                    }
                }
            }
        } else if (imageType.getFamily() == ImageType.Family.PLANAR) {
            int N = imageType.getNumBands();
            if (rule == ConnectRule.FOUR) {
                switch (imageType.getDataType()) {
                    case U8: {
                        return new FhEdgeWeights4_PLU8(N);
                    }
                    case F32: {
                        return new FhEdgeWeights4_PLF32(N);
                    }
                }
            } else if (rule == ConnectRule.EIGHT) {
                switch (imageType.getDataType()) {
                    case U8: {
                        return new FhEdgeWeights8_PLU8(N);
                    }
                    case F32: {
                        return new FhEdgeWeights8_PLF32(N);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown imageType or connect rule");
    }

    public static <T extends ImageBase<T>> SegmentFelzenszwalbHuttenlocher04<T> fh04(@Nullable ConfigFh04 config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigFh04();
        }
        FhEdgeWeights<T> edgeWeights = FactorySegmentationAlg.weightsFelzenszwalb04(config.connectRule, imageType);
        SegmentFelzenszwalbHuttenlocher04<T> alg = new SegmentFelzenszwalbHuttenlocher04<T>(config.K, config.minimumRegionSize, edgeWeights);
        if (config.approximateSortBins > 0) {
            alg.configureApproximateSort(config.approximateSortBins);
        }
        return alg;
    }

    public static <T extends ImageBase<T>> SegmentSlic<T> slic(@Nonnull ConfigSlic config, ImageType<T> imageType) {
        if (config == null) {
            throw new IllegalArgumentException("No default configuration since the number of segments must be specified.");
        }
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            switch (imageType.getDataType()) {
                case U8: {
                    return new SegmentSlic_U8(config.numberOfRegions, config.spacialWeight, config.totalIterations, config.connectRule);
                }
                case F32: {
                    return new SegmentSlic_F32(config.numberOfRegions, config.spacialWeight, config.totalIterations, config.connectRule);
                }
            }
        } else if (imageType.getFamily() == ImageType.Family.PLANAR) {
            int N = imageType.getNumBands();
            switch (imageType.getDataType()) {
                case U8: {
                    return new SegmentSlic_PlU8(config.numberOfRegions, config.spacialWeight, config.totalIterations, config.connectRule, N);
                }
                case F32: {
                    return new SegmentSlic_PlF32(config.numberOfRegions, config.spacialWeight, config.totalIterations, config.connectRule, N);
                }
            }
        }
        throw new IllegalArgumentException("Unknown imageType or connect rule");
    }

    public static WatershedVincentSoille1991 watershed(ConnectRule rule) {
        if (rule == ConnectRule.FOUR) {
            return new WatershedVincentSoille1991.Connect4();
        }
        if (rule == ConnectRule.EIGHT) {
            return new WatershedVincentSoille1991.Connect8();
        }
        throw new IllegalArgumentException("Unknown connectivity rule");
    }
}

