/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.SurfFeatureQueue;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.GrowQueue_F64;

public class WrapDetectDescribeSurf<T extends ImageGray<T>, II extends ImageGray<II>>
implements DetectDescribePoint<T, BrightFeature> {
    protected FastHessianFeatureDetector<II> detector;
    protected OrientationIntegral<II> orientation;
    protected DescribePointSurf<II> describe;
    protected II ii;
    protected SurfFeatureQueue features;
    protected List<ScalePoint> foundPoints;
    protected GrowQueue_F64 featureAngles = new GrowQueue_F64(10);

    public WrapDetectDescribeSurf(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurf<II> describe) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.features = new SurfFeatureQueue(describe.getDescriptionLength());
    }

    @Override
    public BrightFeature createDescription() {
        return this.describe.createDescription();
    }

    @Override
    public BrightFeature getDescription(int index) {
        return (BrightFeature)this.features.get(index);
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    @Override
    public void detect(T input) {
        if (this.ii != null) {
            this.ii.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.ii = GIntegralImageOps.transform(input, this.ii);
        this.features.reset();
        this.featureAngles.reset();
        this.detector.detect(this.ii);
        this.foundPoints = this.detector.getFoundPoints();
        this.features.resize(this.foundPoints.size());
        this.featureAngles.resize(this.foundPoints.size());
        this.computeDescriptors();
    }

    protected void computeDescriptors() {
        this.orientation.setImage(this.ii);
        this.describe.setImage(this.ii);
        for (int i = 0; i < this.foundPoints.size(); ++i) {
            ScalePoint p = this.foundPoints.get(i);
            double radius = p.scale * 2.0;
            this.orientation.setObjectRadius(radius);
            double angle = this.orientation.compute(p.x, p.y);
            this.describe.describe(p.x, p.y, angle, p.scale, (BrightFeature)this.features.get(i));
            this.featureAngles.set(i, angle);
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.foundPoints.get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).scale * 2.0;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

