/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.BaseGeneralFeatureIntensity;
import boofcv.alg.filter.derivative.HessianThreeDeterminant;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class WrapperHessianThreeImageDetIntensity<I extends ImageGray<I>, D extends ImageGray<D>>
extends BaseGeneralFeatureIntensity<I, D> {
    ImageBorder_F32 borderF32 = (ImageBorder_F32)FactoryImageBorder.single((BorderType)BorderType.EXTENDED, GrayF32.class);
    ImageBorder_S32 borderS32 = (ImageBorder_S32)FactoryImageBorder.single((BorderType)BorderType.EXTENDED, GrayU8.class);

    @Override
    public void process(I image, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        this.init(((ImageGray)image).width, ((ImageGray)image).height);
        if (image instanceof GrayU8) {
            HessianThreeDeterminant.process((GrayU8)((GrayU8)image), (GrayF32)this.intensity, (ImageBorder_S32)this.borderS32);
        } else if (image instanceof GrayF32) {
            HessianThreeDeterminant.process((GrayF32)((GrayF32)image), (GrayF32)this.intensity, (ImageBorder_F32)this.borderF32);
        } else {
            throw new IllegalArgumentException("Unsupported input image type");
        }
    }

    @Override
    public QueueCorner getCandidatesMin() {
        return null;
    }

    @Override
    public QueueCorner getCandidatesMax() {
        return null;
    }

    @Override
    public boolean getRequiresGradient() {
        return false;
    }

    @Override
    public boolean getRequiresHessian() {
        return false;
    }

    @Override
    public boolean hasCandidates() {
        return false;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }

    @Override
    public boolean localMinimums() {
        return true;
    }

    @Override
    public boolean localMaximums() {
        return true;
    }
}

