/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.BaseGeneralFeatureIntensity;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.detect.intensity.MedianCornerIntensity;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WrapperMedianCornerIntensity<I extends ImageGray<I>, D extends ImageGray<D>>
extends BaseGeneralFeatureIntensity<I, D> {
    Method m;
    BlurStorageFilter<I> medianFilter;
    I medianImage;

    public WrapperMedianCornerIntensity(BlurStorageFilter<I> medianFilter) {
        this.medianFilter = medianFilter;
        Class imageType = medianFilter.getInputType().getImageClass();
        try {
            this.m = MedianCornerIntensity.class.getMethod("process", imageType, imageType, GrayF32.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(I input, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        this.init(((ImageGray)input).width, ((ImageGray)input).height);
        if (this.medianImage == null) {
            this.medianImage = (ImageGray)input.createNew(((ImageGray)input).width, ((ImageGray)input).height);
        } else {
            this.medianImage.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.medianFilter.process(input, this.medianImage);
        try {
            this.m.invoke(null, input, this.medianImage, this.intensity);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueueCorner getCandidatesMin() {
        return null;
    }

    @Override
    public QueueCorner getCandidatesMax() {
        return null;
    }

    @Override
    public boolean getRequiresGradient() {
        return false;
    }

    @Override
    public boolean getRequiresHessian() {
        return false;
    }

    @Override
    public boolean hasCandidates() {
        return false;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }

    @Override
    public boolean localMinimums() {
        return false;
    }

    @Override
    public boolean localMaximums() {
        return true;
    }
}

