/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.peak.SearchLocalPeak;
import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.intensity.XCornerAbeles2019Intensity;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.ImageStatistics;
import boofcv.concurrency.FWorkArrays;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.peak.ConfigMeanShiftSearch;
import boofcv.factory.feature.detect.peak.FactorySearchLocalPeak;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.CircularIndex;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_I16;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ejml.UtilEjml;

public class DetectChessboardCornersX {
    public float nonmaxThresholdRatio = 0.05f;
    public double edgeIntensityRatioThreshold = 0.01;
    public double edgeAspectRatioThreshold = 0.1;
    public double refinedXCornerThreshold = 0.025;
    public int symmetricTol = 3;
    int blurRadius = 1;
    float nonmaxThreshold;
    GrayF32 blurred = new GrayF32(1, 1);
    BlurFilter<GrayF32> blurFilter;
    SearchLocalPeak<GrayF32> meanShift;
    private FastQueue<ChessboardCorner> corners = new FastQueue(ChessboardCorner.class, true);
    List<ChessboardCorner> filtered = new ArrayList<ChessboardCorner>();
    GrayF32 intensity = new GrayF32(1, 1);
    GrayF32 intensity2x2 = new GrayF32(1, 1);
    public float maxIntensityImage;
    public float considerMaxIntensityImage = 0.0f;
    final ImageBorder<GrayF32> borderInput = FactoryImageBorder.generic((BorderType)BorderType.EXTENDED, (ImageType)ImageType.SB_F32);
    final ImageLineIntegral integral = new ImageLineIntegral();
    final ImageBorder_F32 borderBlur = (ImageBorder_F32)FactoryImageBorder.generic((BorderType)BorderType.EXTENDED, (ImageType)ImageType.SB_F32);
    final InterpolatePixelS<GrayF32> inputInterp = FactoryInterpolation.bilinearPixelS(GrayF32.class, (BorderType)BorderType.ZERO);
    final InterpolatePixelS<GrayF32> intensityInterp = FactoryInterpolation.bilinearPixelS(GrayF32.class, (BorderType)BorderType.ZERO);
    public boolean useMeanShift = true;
    NonMaxSuppression nonmax;
    QueueCorner foundNonmax = new QueueCorner();
    private final int numSpokes = 32;
    private final int numSpokeDiam = 16;
    private final double[] spokesRadi = new double[32];
    private final double[] spokesDiam = new double[16];
    private final double[] smoothedDiam = new double[16];
    private final double[] scoreDiam = new double[16];
    private final Kernel1D_F64 kernelSmooth = (Kernel1D_F64)FactoryKernelGaussian.gaussian((int)1, (boolean)true, (int)64, (double)-1.0, (int)4);
    FastQueue<Point2D_I32> outsideCircle4 = new FastQueue(Point2D_I32.class, true);
    FastQueue<Point2D_I32> outsideCircle3 = new FastQueue(Point2D_I32.class, true);
    private final float[] outsideCircleValues;
    GrayF32 tmp = new GrayF32(1, 1);
    FWorkArrays fwork = new FWorkArrays();

    public DetectChessboardCornersX() {
        Object config = new ConfigExtract();
        config.radius = 1;
        config.threshold = 0.0f;
        config.detectMaximums = true;
        config.detectMinimums = false;
        config.useStrictRule = true;
        this.nonmax = FactoryFeatureExtractor.nonmax(config);
        this.blurFilter = FactoryBlurFilter.gaussian((ImageType)ImageType.SB_F32, (double)-1.0, (int)this.blurRadius);
        this.borderInput.setImage((ImageBase)new GrayF32(1, 1));
        this.integral.setImage(FactoryGImageGray.wrap(this.borderInput));
        config = new ConfigMeanShiftSearch(5, 1.0E-6);
        ((ConfigMeanShiftSearch)config).positiveOnly = true;
        ((ConfigMeanShiftSearch)config).odd = false;
        this.meanShift = FactorySearchLocalPeak.meanShiftGaussian((ConfigMeanShiftSearch)config, GrayF32.class);
        this.meanShift.setSearchRadius(2);
        DiscretizedCircle.coordinates((double)4.0, this.outsideCircle4);
        DiscretizedCircle.coordinates((double)3.0, this.outsideCircle3);
        this.outsideCircleValues = new float[this.outsideCircle4.size];
        this.borderBlur.setImage((ImageBase)this.blurred);
        this.intensityInterp.setImage((ImageBase)this.intensity);
        this.meanShift.setImage(this.intensity);
    }

    public void process(GrayF32 input) {
        ChessboardCorner c;
        int i;
        this.filtered.clear();
        this.corners.reset();
        this.foundNonmax.reset();
        this.borderInput.setImage((ImageBase)input);
        this.inputInterp.setImage((ImageBase)input);
        this.blurFilter.process((ImageBase)input, (ImageBase)this.blurred);
        XCornerAbeles2019Intensity.process(this.blurred, this.intensity);
        ConvolveImageMean.horizontal((GrayF32)this.intensity, (GrayF32)this.tmp, (int)0, (int)2);
        ConvolveImageMean.vertical((GrayF32)this.tmp, (GrayF32)this.intensity2x2, (int)0, (int)2, (FWorkArrays)this.fwork);
        this.maxIntensityImage = ImageStatistics.max((GrayF32)this.intensity2x2);
        this.nonmaxThreshold = Math.max(this.considerMaxIntensityImage, this.maxIntensityImage) * this.nonmaxThresholdRatio * this.nonmaxThresholdRatio;
        this.nonmax.setThresholdMaximum(this.nonmaxThreshold);
        this.nonmax.process(this.intensity2x2, null, null, null, this.foundNonmax);
        for (int i2 = 0; i2 < this.foundNonmax.size; ++i2) {
            Point2D_I16 c2 = (Point2D_I16)this.foundNonmax.get(i2);
            ChessboardCorner corner = (ChessboardCorner)((Object)this.corners.grow());
            corner.reset();
            corner.set((double)c2.x + 0.5, (double)c2.y + 0.5);
        }
        double maxEdge = 0.0;
        double maxIntensity = 0.0;
        for (i = 0; i < this.corners.size(); ++i) {
            c = (ChessboardCorner)((Object)this.corners.get(i));
            int xx = (int)(c.x + 0.5);
            int yy = (int)(c.y + 0.5);
            if (xx < 3 || yy < 3 || xx >= input.width - 3 || yy >= input.height - 3 || !this.checkPositiveInside(xx, yy, 4) || !this.checkNegativeInside(xx, yy, 12) || !this.checkChessboardCircle((float)c.x, (float)c.y, this.outsideCircle4, 3, 6, this.symmetricTol) || !this.checkChessboardCircle((float)c.x, (float)c.y, this.outsideCircle3, 3, 4, this.symmetricTol)) continue;
            if (this.useMeanShift) {
                this.meanShift.search((float)c.x, (float)c.y);
                c.x = this.meanShift.getPeakX();
                c.y = this.meanShift.getPeakY();
            }
            if (!this.checkChessboardCircle((float)c.x, (float)c.y, this.outsideCircle4, 4, 4, this.symmetricTol - 1)) {
                c.edgeIntensity = -1.0;
                continue;
            }
            if (!this.checkEigenCorner(c)) {
                c.edgeIntensity = -1.0;
                continue;
            }
            if (!this.computeFeatures(c)) {
                c.edgeIntensity = -1.0;
                continue;
            }
            c.x += 0.5;
            c.y += 0.5;
            maxEdge = Math.max(maxEdge, c.edgeIntensity);
            maxIntensity = Math.max(c.intensity, maxIntensity);
        }
        for (i = this.corners.size - 1; i >= 0; --i) {
            c = (ChessboardCorner)((Object)this.corners.get(i));
            if (!(c.edgeIntensity >= this.edgeIntensityRatioThreshold * maxEdge)) continue;
            this.filtered.add(c);
        }
    }

    boolean checkPositiveInside(int cx, int cy, int threshold) {
        int radius = 1;
        int x0 = cx - radius;
        int y0 = cy - radius;
        int x1 = cx + radius + 1;
        int y1 = cy + radius + 1;
        int count = 0;
        for (int y = y0; y < y1; ++y) {
            for (int x = x0; x < x1; ++x) {
                if (!(this.intensity.unsafe_get(x, y) >= this.nonmaxThreshold)) continue;
                ++count;
            }
        }
        return count >= threshold;
    }

    boolean checkNegativeInside(int cx, int cy, int threshold) {
        int radius = 3;
        int x0 = cx - radius;
        int y0 = cy - radius;
        int x1 = cx + radius + 1;
        int y1 = cy + radius + 1;
        int count = 0;
        for (int y = y0; y < y1; ++y) {
            for (int x = x0; x < x1; ++x) {
                if (!(this.intensity.unsafe_get(x, y) <= -this.nonmaxThreshold)) continue;
                ++count;
            }
        }
        return count >= threshold;
    }

    private boolean checkChessboardCircle(float cx, float cy, FastQueue<Point2D_I32> outside, int min, int max, int symmetric) {
        float mean = 0.0f;
        for (int i = 0; i < outside.size; ++i) {
            float v;
            Point2D_I32 p = (Point2D_I32)outside.get(i);
            this.outsideCircleValues[i] = v = this.inputInterp.get(cx + (float)p.x, cy + (float)p.y);
            mean += v;
        }
        int numUpDown = 0;
        int prevDir = this.outsideCircleValues[0] > (mean /= (float)outside.size) ? 1 : -1;
        for (int i = 1; i < outside.size; ++i) {
            int dir;
            int n = dir = this.outsideCircleValues[i] > mean ? 1 : -1;
            if (prevDir == dir) continue;
            ++numUpDown;
            prevDir = dir;
        }
        int numMirror = 0;
        int halfCount = outside.size / 2;
        for (int i = 0; i < halfCount; ++i) {
            int dirJ;
            int dirI = this.outsideCircleValues[i] > mean ? 1 : -1;
            int n = dirJ = this.outsideCircleValues[i + halfCount] > mean ? 1 : -1;
            if (dirI != dirJ) continue;
            ++numMirror;
        }
        return numUpDown >= min && numUpDown <= max && numMirror >= halfCount - symmetric;
    }

    private boolean checkEigenCorner(ChessboardCorner c) {
        int radius = 3;
        int cx = (int)(c.x + 0.5);
        int cy = (int)(c.y + 0.5);
        float xx = 0.0f;
        float yy = 0.0f;
        float xy = 0.0f;
        int width = radius * 2 + 1;
        int idx = 0;
        for (int iy = 0; iy < width; ++iy) {
            int ix = 0;
            while (ix < width) {
                int y = cy + iy - radius;
                int x = cx + ix - radius;
                float dx = this.borderBlur.get(x + 1, y) - this.borderBlur.get(x - 1, y);
                float dy = this.borderBlur.get(x, y + 1) - this.borderBlur.get(x, y - 1);
                xx += dx * dx;
                xy += dx * dy;
                yy += dy * dy;
                ++ix;
                ++idx;
            }
        }
        float totalWeight = width * width;
        float left = ((xx /= totalWeight) + (yy /= totalWeight)) * 0.5f;
        float b = (xx - yy) * 0.5f;
        float right = (float)Math.sqrt(b * b + (xy /= totalWeight) * xy);
        c.edgeIntensity = left - right;
        c.edgeRatio = (left - right) / (left + right);
        return c.edgeRatio >= this.edgeAspectRatioThreshold;
    }

    private boolean computeFeatures(ChessboardCorner corner) {
        double r = 4.0;
        double cx = corner.x;
        double cy = corner.y;
        double sumDifference = 0.0;
        double mean = 0.0;
        for (int i = 0; i < 16; ++i) {
            int j = (i + 16) % 32;
            double angle = Math.PI * (double)i / 16.0;
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            double valA = this.spokesRadi[i] = this.integral.compute(cx, cy, cx + r * c, cy + r * s) / r;
            double valB = this.spokesRadi[j] = this.integral.compute(cx, cy, cx - r * c, cy - r * s) / r;
            this.spokesDiam[i] = valA + valB;
            sumDifference += Math.abs(valA - valB);
            mean += valA + valB;
        }
        mean /= 32.0;
        sumDifference /= 16.0;
        this.smoothSpokeDiam();
        int bestSpoke = -1;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            int j = (i + 8) % 16;
            this.scoreDiam[i] = this.smoothedDiam[i] - this.smoothedDiam[j];
            double score = this.scoreDiam[i];
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestSpoke = i;
        }
        double value0 = this.scoreDiam[CircularIndex.addOffset((int)bestSpoke, (int)-1, (int)16)];
        double value2 = this.scoreDiam[CircularIndex.addOffset((int)bestSpoke, (int)1, (int)16)];
        double adjustedIndex = (double)bestSpoke + FastHessianFeatureDetector.polyPeak(value0, (double)bestSpoke, value2);
        corner.orientation = UtilAngle.boundHalf((double)(Math.PI * adjustedIndex / 16.0));
        double stdev = 0.0;
        for (int i = 0; i < 32; ++i) {
            double diff = mean - this.spokesRadi[i];
            stdev += diff * diff;
        }
        stdev = Math.sqrt(stdev / 32.0);
        corner.intensity = -bestScore * stdev / (sumDifference + UtilEjml.EPS);
        corner.constrast = (this.scoreDiam[(bestSpoke + 8) % 16] - this.scoreDiam[bestSpoke]) / 2.0;
        return corner.intensity >= this.refinedXCornerThreshold;
    }

    private void smoothSpokeDiam() {
        int r_smooth = this.kernelSmooth.getRadius();
        int w_smooth = this.kernelSmooth.getWidth();
        for (int i = 0; i < 16; ++i) {
            int start = CircularIndex.addOffset((int)i, (int)(-r_smooth), (int)16);
            double sum = 0.0;
            for (int j = 0; j < w_smooth; ++j) {
                int index = CircularIndex.addOffset((int)start, (int)j, (int)16);
                sum += this.spokesDiam[index] * this.kernelSmooth.data[j];
            }
            this.smoothedDiam[i] = sum;
        }
    }

    public GrayF32 getBlurred() {
        return this.blurred;
    }

    public GrayF32 getIntensity() {
        return this.intensity;
    }

    public List<ChessboardCorner> getCorners() {
        return this.filtered;
    }

    public float getNonmaxThresholdRatio() {
        return this.nonmaxThresholdRatio;
    }

    public void setNonmaxThresholdRatio(float nonmaxThresholdRatio) {
        this.nonmaxThresholdRatio = nonmaxThresholdRatio;
    }

    public void setRefinedXCornerThreshold(double refinedXCornerThreshold) {
        this.refinedXCornerThreshold = refinedXCornerThreshold;
    }

    public double getEdgeIntensityRatioThreshold() {
        return this.edgeIntensityRatioThreshold;
    }

    public void setEdgeIntensityRatioThreshold(double edgeIntensityRatioThreshold) {
        this.edgeIntensityRatioThreshold = edgeIntensityRatioThreshold;
    }

    public int getNonmaxRadius() {
        return this.nonmax.getSearchRadius();
    }

    public void setNonmaxRadius(int nonmaxRadius) {
        this.nonmax.setSearchRadius(nonmaxRadius);
    }
}

