/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.Match;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastQueue;

public class TemplateMatching<T extends ImageBase<T>> {
    private TemplateMatchingIntensity<T> match;
    private NonMaxSuppression extractor;
    private T template;
    private T mask;
    private int maxMatches;
    private QueueCorner candidates = new QueueCorner(10);
    private float[] scores = new float[10];
    private int[] indexes = new int[10];
    private FastQueue<Match> results = new FastQueue(10, Match.class, true);
    int imageWidth;
    int imageHeight;

    public TemplateMatching(TemplateMatchingIntensity<T> match) {
        this.match = match;
        ConfigExtract config = match.isMaximize() ? new ConfigExtract(2, -3.4028235E38f, 0, true) : new ConfigExtract(2, -3.4028235E38f, 0, true, true, false);
        this.extractor = FactoryFeatureExtractor.nonmax(config);
    }

    public void setMinimumSeparation(int radius) {
        this.extractor.setSearchRadius(radius);
    }

    public void setTemplate(T template, T mask, int maxMatches) {
        this.template = template;
        this.mask = mask;
        this.maxMatches = maxMatches;
    }

    public void setImage(T image) {
        this.match.setInputImage(image);
        this.imageWidth = ((ImageBase)image).width;
        this.imageHeight = ((ImageBase)image).height;
    }

    public void process() {
        if (this.mask == null) {
            this.match.process(this.template);
        } else {
            this.match.process(this.template, this.mask);
        }
        GrayF32 intensity = this.match.getIntensity();
        int offsetX = 0;
        int offsetY = 0;
        if (!this.match.isBorderProcessed()) {
            int x0 = this.match.getBorderX0();
            int x1 = this.imageWidth - this.match.getBorderX1();
            int y0 = this.match.getBorderY0();
            int y1 = this.imageHeight - this.match.getBorderY1();
            intensity = (GrayF32)intensity.subimage(x0, y0, x1 + 1, y1 + 1, null);
        } else {
            offsetX = this.match.getBorderX0();
            offsetY = this.match.getBorderY0();
        }
        this.candidates.reset();
        if (this.match.isMaximize()) {
            this.extractor.process(intensity, null, null, null, this.candidates);
        } else {
            this.extractor.process(intensity, null, null, this.candidates, null);
        }
        if (this.scores.length < this.candidates.size) {
            this.scores = new float[this.candidates.size];
            this.indexes = new int[this.candidates.size];
        }
        float sgn = this.match.isMaximize() ? -1.0f : 1.0f;
        for (int i = 0; i < this.candidates.size; ++i) {
            Point2D_I16 p = (Point2D_I16)this.candidates.get(i);
            this.scores[i] = sgn * intensity.get((int)p.x, (int)p.y);
        }
        int N = Math.min(this.maxMatches, this.candidates.size);
        QuickSelect.selectIndex((float[])this.scores, (int)N, (int)this.candidates.size, (int[])this.indexes);
        this.results.reset();
        for (int i = 0; i < N; ++i) {
            Point2D_I16 p = (Point2D_I16)this.candidates.get(this.indexes[i]);
            Match m = (Match)((Object)this.results.grow());
            m.score = -this.scores[this.indexes[i]];
            m.set(p.x - offsetX, p.y - offsetY);
        }
    }

    public FastQueue<Match> getResults() {
        return this.results;
    }
}

