/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block;

import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public interface BlockRowScore<T extends ImageBase<T>, ScoreArray, ImageData> {
    public void setBorder(ImageBorder<T> var1);

    public void setInput(T var1, T var2);

    public void scoreRow(int var1, ImageData var2, ImageData var3, ScoreArray var4, int var5, int var6, int var7, ScoreArray var8);

    public void score(ImageData var1, ImageData var2, int var3, int var4, int var5, int var6, ScoreArray var7);

    public int getMaxPerPixelError();

    public boolean isRequireNormalize();

    public void normalizeRegionScores(int var1, ScoreArray var2, int var3, int var4, int var5, int var6, ScoreArray var7);

    public void normalizeScore(int var1, int var2, int var3, int var4, int var5, int var6, ScoreArray var7, int var8, ScoreArray var9);

    public ImageType<T> getImageType();

    public static abstract class ArrayS32_BF32
    extends ArrayF32<GrayF32> {
        ImageBorder_F32 borderLeft;
        ImageBorder_F32 borderRight;

        @Override
        public void setBorder(ImageBorder<GrayF32> border) {
            this.borderLeft = (ImageBorder_F32)border.copy();
            this.borderRight = (ImageBorder_F32)border.copy();
        }

        @Override
        public void setInput(GrayF32 left, GrayF32 right) {
            super.setInput(left, right);
            this.borderLeft.setImage((ImageBase)left);
            this.borderRight.setImage((ImageBase)right);
        }
    }

    public static abstract class ArrayF32<T extends ImageBase<T>>
    implements BlockRowScore<T, float[], float[]> {
        T left;
        T right;

        @Override
        public void setInput(T left, T right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void scoreRow(int row, float[] leftRow, float[] rightRow, float[] scores, int disparityMin, int disparityMax, int regionWidth, float[] elementScore) {
            int regionRadius = regionWidth / 2;
            int widthAndBorder = ((ImageBase)this.left).width + 2 * regionRadius;
            for (int d = disparityMin; d <= disparityMax; ++d) {
                int dispFromMin = d - disparityMin;
                this.score(leftRow, rightRow, d, 0, 0, widthAndBorder - d, elementScore);
                float score = 0.0f;
                for (int i = 0; i < regionWidth; ++i) {
                    score += elementScore[i];
                }
                int indexScore = ((ImageBase)this.left).width * dispFromMin + dispFromMin;
                scores[indexScore++] = score;
                int col = 0;
                while (col < ((ImageBase)this.left).width - dispFromMin - 1) {
                    scores[indexScore] = score += elementScore[col + regionWidth] - elementScore[col];
                    ++col;
                    ++indexScore;
                }
            }
        }

        @Override
        public void normalizeRegionScores(int row, float[] scores, int disparityMin, int disparityMax, int regionWidth, int regionHeight, float[] scoresNorm) {
            for (int d = disparityMin; d <= disparityMax; ++d) {
                int dispFromMin = d - disparityMin;
                int colMax = ((ImageBase)this.left).width - d;
                int indexScore = ((ImageBase)this.left).width * dispFromMin + dispFromMin;
                this.normalizeScore(row, d, 0, colMax, regionWidth, regionHeight, scores, indexScore, scoresNorm);
            }
        }

        @Override
        public void normalizeScore(int row, int colLeft, int colRight, int numCols, int regionWidth, int regionHeight, float[] scores, int indexScores, float[] scoresNorm) {
        }

        @Override
        public int getMaxPerPixelError() {
            throw new RuntimeException("Maximum error is not supported for the image type");
        }
    }

    public static abstract class ArrayS32_BS64
    extends ArrayS32<GrayS64, long[]> {
        ImageBorder_S64 borderLeft;
        ImageBorder_S64 borderRight;

        protected ArrayS32_BS64(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public void setBorder(ImageBorder<GrayS64> border) {
            this.borderLeft = (ImageBorder_S64)border.copy();
            this.borderRight = (ImageBorder_S64)border.copy();
        }

        @Override
        public void setInput(GrayS64 left, GrayS64 right) {
            super.setInput(left, right);
            this.borderLeft.setImage((ImageBase)left);
            this.borderRight.setImage((ImageBase)right);
        }
    }

    public static abstract class ArrayS32_BS32<T extends GrayI<T>, ImageData>
    extends ArrayS32<T, ImageData> {
        ImageBorder_S32<T> borderLeft;
        ImageBorder_S32<T> borderRight;

        protected ArrayS32_BS32(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public void setBorder(ImageBorder<T> border) {
            this.borderLeft = (ImageBorder_S32)border.copy();
            this.borderRight = (ImageBorder_S32)border.copy();
        }

        @Override
        public void setInput(T left, T right) {
            super.setInput(left, right);
            this.borderLeft.setImage(left);
            this.borderRight.setImage(right);
        }
    }

    public static abstract class ArrayS32<T extends ImageBase<T>, ImageData>
    implements BlockRowScore<T, int[], ImageData> {
        protected int maxPerPixel;
        T left;
        T right;

        protected ArrayS32(int maxPerPixel) {
            this.maxPerPixel = maxPerPixel;
        }

        @Override
        public void setInput(T left, T right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void scoreRow(int row, ImageData leftRow, ImageData rightRow, int[] scores, int disparityMin, int disparityMax, int regionWidth, int[] elementScore) {
            int regionRadius = regionWidth / 2;
            int widthAndBorder = ((ImageBase)this.left).width + regionRadius * 2;
            for (int d = disparityMin; d <= disparityMax; ++d) {
                int dispFromMin = d - disparityMin;
                this.score(leftRow, rightRow, d, 0, 0, widthAndBorder - d, elementScore);
                int score = 0;
                for (int i = 0; i < regionWidth; ++i) {
                    score += elementScore[i];
                }
                int indexScore = ((ImageBase)this.left).width * dispFromMin + dispFromMin;
                scores[indexScore++] = score;
                int col = 0;
                while (col < ((ImageBase)this.left).width - dispFromMin - 1) {
                    scores[indexScore] = score += elementScore[col + regionWidth] - elementScore[col];
                    ++col;
                    ++indexScore;
                }
            }
        }

        @Override
        public void normalizeRegionScores(int row, int[] scores, int disparityMin, int disparityMax, int regionWidth, int regionHeight, int[] scoresNorm) {
            for (int d = disparityMin; d <= disparityMax; ++d) {
                int dispFromMin = d - disparityMin;
                int colMax = ((ImageBase)this.left).width - d;
                int indexScore = ((ImageBase)this.left).width * dispFromMin + dispFromMin;
                this.normalizeScore(row, d, 0, colMax, regionWidth, regionHeight, scores, indexScore, scoresNorm);
            }
        }

        @Override
        public void normalizeScore(int row, int colLeft, int colRight, int numCols, int regionWidth, int regionHeight, int[] scores, int indexScores, int[] scoresNorm) {
        }

        @Override
        public int getMaxPerPixelError() {
            if (this.maxPerPixel < 0) {
                throw new RuntimeException("Not supported");
            }
            return this.maxPerPixel;
        }
    }
}

