/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.score;

import boofcv.alg.feature.disparity.block.DisparitySparseScoreSadRect;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import java.util.Arrays;

public class DisparitySparseScoreBM_SAD_U8
extends DisparitySparseScoreSadRect<int[], GrayU8> {
    int[] scores;

    public DisparitySparseScoreBM_SAD_U8(int radiusX, int radiusY) {
        super(radiusX, radiusY);
    }

    @Override
    public void configure(int disparityMin, int disparityRange) {
        super.configure(disparityMin, disparityRange);
        this.scores = new int[disparityRange];
    }

    @Override
    public boolean process(int x, int y) {
        if (x < this.disparityMin) {
            return false;
        }
        this.localMaxRange = Math.min(x, this.disparityMax) - this.disparityMin + 1;
        Arrays.fill(this.scores, 0);
        if (x < this.localMaxRange + this.radiusX + this.disparityMin || x >= ((GrayU8)this.left).width - this.radiusX || y < this.radiusY || y >= ((GrayU8)this.left).height - this.radiusY) {
            this.scoreBorder(x, y);
        } else {
            this.scoreInner(x, y);
        }
        return true;
    }

    private void scoreBorder(int cx, int cy) {
        ImageBorder_S32 bleft = (ImageBorder_S32)this.bleft;
        ImageBorder_S32 bright = (ImageBorder_S32)this.bright;
        for (int y = -this.radiusY; y <= this.radiusY; ++y) {
            int d = 0;
            while (d < this.localMaxRange) {
                int score = 0;
                for (int x = -this.radiusX; x <= this.radiusX; ++x) {
                    int diff = bleft.get(cx + x, cy + y) - bright.get(cx + x - d - this.disparityMin, cy + y);
                    score += Math.abs(diff);
                }
                int n = d++;
                this.scores[n] = this.scores[n] + score;
            }
        }
    }

    private void scoreInner(int x, int y) {
        for (int row = 0; row < this.regionHeight; ++row) {
            int startLeft = ((GrayU8)this.left).startIndex + ((GrayU8)this.left).stride * (y - this.radiusY + row) + x - this.radiusX;
            int startRight = ((GrayU8)this.right).startIndex + ((GrayU8)this.right).stride * (y - this.radiusY + row) + x - this.radiusX - this.disparityMin;
            int i = 0;
            while (i < this.localMaxRange) {
                int indexLeft = startLeft;
                int indexRight = startRight - i;
                int score = 0;
                for (int j = 0; j < this.regionWidth; ++j) {
                    int diff = (((GrayU8)this.left).data[indexLeft++] & 0xFF) - (((GrayU8)this.right).data[indexRight++] & 0xFF);
                    score += Math.abs(diff);
                }
                int n = i++;
                this.scores[n] = this.scores[n] + score;
            }
        }
    }

    @Override
    public int[] getScore() {
        return this.scores;
    }

    @Override
    public Class<GrayU8> getImageType() {
        return GrayU8.class;
    }
}

