/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.select;

import boofcv.alg.feature.disparity.block.SelectSparseStandardWta;

public class SelectSparseErrorWithChecksWta_F32
extends SelectSparseStandardWta<float[]> {
    protected float textureThreshold;

    public SelectSparseErrorWithChecksWta_F32(int maxError, double texture) {
        super(maxError, texture);
    }

    @Override
    protected void setTexture(double texture) {
        this.textureThreshold = (float)texture;
    }

    @Override
    public boolean select(float[] scores, int disparityMax) {
        int disparity = 0;
        float best = scores[0];
        for (int i = 1; i < disparityMax; ++i) {
            if (!(scores[i] < best)) continue;
            best = scores[i];
            disparity = i;
        }
        if (best > (float)this.maxError) {
            return false;
        }
        if (this.textureThreshold > 0.0f) {
            int i;
            float secondBest = Float.MAX_VALUE;
            for (i = 0; i < disparity - 1; ++i) {
                if (!(scores[i] < secondBest)) continue;
                secondBest = scores[i];
            }
            for (i = disparity + 2; i < disparityMax; ++i) {
                if (!(scores[i] < secondBest)) continue;
                secondBest = scores[i];
            }
            if (secondBest - best <= this.textureThreshold * best) {
                return false;
            }
        }
        this.disparity = disparity;
        return true;
    }
}

