/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.sgm;

import boofcv.alg.feature.disparity.sgm.SgmHelper;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class SgmDisparitySelector {
    protected final SgmHelper helper = new SgmHelper();
    protected int rightToLeftTolerance = 1;
    int maxError = Integer.MAX_VALUE;
    double textureThreshold = 0.0;
    int disparityMin = 0;
    int invalidDisparity = -1;
    int lengthY;
    int lengthX;
    int lengthD;

    public void select(Planar<GrayU16> costYXD, Planar<GrayU16> aggregatedYXD, GrayU8 disparity) {
        this.setup(aggregatedYXD);
        disparity.reshape(this.lengthX, this.lengthY);
        for (int y = 0; y < this.lengthY; ++y) {
            int x;
            GrayU16 aggregatedXD = (GrayU16)aggregatedYXD.getBand(y);
            for (x = 0; x < this.disparityMin; ++x) {
                disparity.unsafe_set(x, y, this.invalidDisparity);
            }
            for (x = this.disparityMin; x < this.lengthX; ++x) {
                disparity.unsafe_set(x, y, this.findBestDisparity(x, aggregatedXD));
            }
        }
    }

    void setup(Planar<GrayU16> aggregatedYXD) {
        this.lengthY = aggregatedYXD.getNumBands();
        this.lengthX = aggregatedYXD.height;
        this.lengthD = aggregatedYXD.width;
        this.invalidDisparity = SgmDisparitySelector.invalidGivenRange(this.lengthD);
        this.helper.configure(this.lengthX, this.disparityMin, this.lengthD);
        if (this.invalidDisparity > 255) {
            throw new IllegalArgumentException("Disparity range is too great. Must be < 256 not " + this.lengthD);
        }
    }

    int findBestDisparity(int x, GrayU16 aggregatedXD) {
        int bestRange_R_to_L;
        int localMaxRange = this.helper.localDisparityRangeLeft(x);
        int bestScore = Integer.MAX_VALUE;
        int bestRange = this.invalidDisparity;
        int idx = aggregatedXD.getIndex(0, x - this.disparityMin);
        for (int d = 0; d < localMaxRange; ++d) {
            int cost = aggregatedXD.data[idx + d] & 0xFFFF;
            if (cost >= bestScore) continue;
            bestScore = cost;
            bestRange = d;
        }
        if (bestRange == this.invalidDisparity) {
            return this.invalidDisparity;
        }
        if (bestScore > this.maxError) {
            return this.invalidDisparity;
        }
        if (this.rightToLeftTolerance >= 0 && Math.abs((bestRange_R_to_L = this.selectRightToLeft(x - bestRange - this.disparityMin, aggregatedXD)) - bestRange) > this.rightToLeftTolerance) {
            return this.invalidDisparity;
        }
        if (localMaxRange > 3 && this.textureThreshold > 0.0) {
            int v;
            int d;
            int secondBest = Integer.MAX_VALUE;
            for (d = 0; d < bestRange - 1; ++d) {
                v = aggregatedXD.data[idx + d] & 0xFFFF;
                if (v >= secondBest) continue;
                secondBest = v;
            }
            for (d = bestRange + 2; d < localMaxRange; ++d) {
                v = aggregatedXD.data[idx + d] & 0xFFFF;
                if (v >= secondBest) continue;
                secondBest = v;
            }
            if ((double)(secondBest - bestScore) <= this.textureThreshold * (double)bestScore) {
                bestRange = this.invalidDisparity;
            }
        }
        return bestRange;
    }

    private int selectRightToLeft(int x, GrayU16 aggregatedXD) {
        int localDisparityRange = this.helper.localDisparityRangeRight(x);
        if (localDisparityRange <= 0) {
            return x;
        }
        int idx = aggregatedXD.getIndex(0, x);
        int bestD = 0;
        float scoreBest = aggregatedXD.data[idx] & 0xFFFF;
        for (int i = 1; i < localDisparityRange; ++i) {
            int s = aggregatedXD.data[(idx += this.lengthD) + i] & 0xFFFF;
            if (!((float)s < scoreBest)) continue;
            scoreBest = s;
            bestD = i;
        }
        return bestD;
    }

    public int getRightToLeftTolerance() {
        return this.rightToLeftTolerance;
    }

    public void setRightToLeftTolerance(int rightToLeftTolerance) {
        this.rightToLeftTolerance = rightToLeftTolerance;
    }

    public int getMaxError() {
        return this.maxError;
    }

    public void setMaxError(int maxError) {
        this.maxError = maxError;
    }

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public void setDisparityMin(int disparityMin) {
        this.disparityMin = disparityMin;
    }

    public int getInvalidDisparity() {
        return this.invalidDisparity;
    }

    public double getTextureThreshold() {
        return this.textureThreshold;
    }

    public void setTextureThreshold(double textureThreshold) {
        this.textureThreshold = textureThreshold;
    }

    public static int invalidGivenRange(int disparityRange) {
        return disparityRange;
    }
}

