/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.sgm;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.disparity.sgm.SgmDisparitySelector;
import boofcv.alg.feature.disparity.sgm.SgmStereoDisparityError;
import boofcv.alg.feature.disparity.sgm.cost.SgmCostFromBlocks;
import boofcv.alg.feature.disparity.sgm.cost.SgmMutualInformation_U8;
import boofcv.alg.feature.disparity.sgm.cost.StereoMutualInformation;
import boofcv.alg.transform.pyramid.ConfigPyramid2;
import boofcv.alg.transform.pyramid.PyramidDiscreteNN2;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.util.Random;

public class SgmStereoDisparityHmi
extends SgmStereoDisparityError<GrayU8> {
    protected Random rand = new Random(234L);
    protected StereoMutualInformation stereoMI;
    protected int extraIterations = 0;
    protected PyramidDiscreteNN2<GrayU8> pyrLeft = new PyramidDiscreteNN2(ImageType.single(GrayU8.class));
    protected PyramidDiscreteNN2<GrayU8> pyrRight = new PyramidDiscreteNN2(ImageType.single(GrayU8.class));

    public SgmStereoDisparityHmi(ConfigPyramid2 configPyr, StereoMutualInformation stereoMI, SgmDisparitySelector selector) {
        super(new SgmMutualInformation_U8(stereoMI), selector);
        this.stereoMI = stereoMI;
        this.pyrLeft.getConfigLayers().set(configPyr);
        this.pyrRight.getConfigLayers().set(configPyr);
    }

    public SgmStereoDisparityHmi(ConfigPyramid2 configPyr, StereoMutualInformation stereoMI, SgmDisparitySelector selector, SgmCostFromBlocks<GrayU8> blockScore) {
        super(blockScore, selector);
        this.stereoMI = stereoMI;
        this.pyrLeft.getConfigLayers().set(configPyr);
        this.pyrRight.getConfigLayers().set(configPyr);
    }

    @Override
    public void process(GrayU8 left, GrayU8 right) {
        InputSanityCheck.checkSameShape((ImageBase)left, (ImageBase)right);
        this.disparity.reshape((ImageBase)left);
        this.helper.configure(left.width, this.disparityMin, this.disparityRange);
        this.pyrLeft.process((ImageBase)left);
        this.pyrRight.process((ImageBase)right);
        this.stereoMI.diagonalHistogram(1.0, 2047);
        int tol_R_to_L = this.selector.getRightToLeftTolerance();
        double textureThreshold = this.selector.getTextureThreshold();
        for (int level = this.pyrLeft.getLevelsCount() - 1; level >= 0; --level) {
            int scale = 1 << level;
            int levelDisparityMin = (int)Math.round((double)this.disparityMin / (double)scale);
            int levelDisparityRange = (int)Math.ceil((double)this.disparityRange / (double)scale);
            GrayU8 levelLeft = (GrayU8)this.pyrLeft.get(level);
            GrayU8 levelRight = (GrayU8)this.pyrRight.get(level);
            if (level > 0) {
                this.selector.setTextureThreshold(-1.0);
                this.selector.setRightToLeftTolerance(-1);
            } else {
                this.selector.setTextureThreshold(textureThreshold);
                this.selector.setRightToLeftTolerance(tol_R_to_L);
            }
            this.sgmCost.configure(levelDisparityMin, levelDisparityRange);
            this.aggregation.configure(levelDisparityMin);
            this.sgmCost.process(levelLeft, levelRight, (Planar<GrayU16>)this.costYXD);
            this.aggregation.process((Planar<GrayU16>)this.costYXD);
            this.selector.setDisparityMin(levelDisparityMin);
            this.selector.select((Planar<GrayU16>)this.costYXD, this.aggregation.getAggregated(), this.disparity);
            if (level <= 0) continue;
            int invalid = this.selector.getInvalidDisparity();
            this.stereoMI.process(levelLeft, levelRight, levelDisparityMin, this.disparity, invalid);
            this.stereoMI.precomputeScaledCost(2047);
        }
        for (int i = 0; i < this.extraIterations; ++i) {
            this.stereoMI.process(left, right, this.disparityMin, this.disparity, this.selector.getInvalidDisparity());
            this.stereoMI.precomputeScaledCost(2047);
            this.sgmCost.configure(this.disparityMin, this.disparityRange);
            this.aggregation.configure(this.disparityMin);
            this.sgmCost.process(left, right, (Planar<GrayU16>)this.costYXD);
            this.aggregation.process((Planar<GrayU16>)this.costYXD);
            this.selector.setDisparityMin(this.disparityMin);
            this.selector.select((Planar<GrayU16>)this.costYXD, this.aggregation.getAggregated(), this.disparity);
        }
    }

    public void process(GrayU8 left, GrayU8 right, GrayU8 disparityEst, int invalid) {
        InputSanityCheck.checkSameShape((ImageBase)left, (ImageBase)right, (ImageBase)disparityEst);
        this.stereoMI.process(left, right, this.disparityMin, disparityEst, invalid);
        this.stereoMI.precomputeScaledCost(2047);
        super.process(left, right);
    }

    public StereoMutualInformation getStereoMI() {
        return this.stereoMI;
    }

    public PyramidDiscreteNN2<GrayU8> getPyrLeft() {
        return this.pyrLeft;
    }

    public PyramidDiscreteNN2<GrayU8> getPyrRight() {
        return this.pyrRight;
    }

    public int getExtraIterations() {
        return this.extraIterations;
    }

    public void setExtraIterations(int extraIterations) {
        this.extraIterations = extraIterations;
    }
}

