/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianDerivBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianThreeImageDetIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperLaplacianBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FactoryIntensityPoint {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> fast(int pixelTol, int minCont, Class<I> imageType) {
        FastCornerDetector<I> alg = FactoryIntensityPointAlg.fast(pixelTol, minCont, imageType);
        return new WrapperFastCornerIntensity(alg);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> harris(int windowRadius, float kappa, boolean weighted, Class<D> derivType) {
        GradientCornerIntensity<D> alg = FactoryIntensityPointAlg.harris(windowRadius, kappa, weighted, derivType);
        return new WrapperGradientCornerIntensity(alg);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> shiTomasi(int windowRadius, boolean weighted, Class<D> derivType) {
        GradientCornerIntensity<D> alg = FactoryIntensityPointAlg.shiTomasi(windowRadius, weighted, derivType);
        return new WrapperGradientCornerIntensity(alg);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> kitros(Class<D> derivType) {
        return new WrapperKitRosCornerIntensity(derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> median(int radius, Class<I> imageType) {
        BlurStorageFilter filter = FactoryBlurFilter.median((ImageType)ImageType.single(imageType), (int)radius);
        return new WrapperMedianCornerIntensity(filter);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> hessian(HessianBlobIntensity.Type type, Class<D> derivType) {
        return new WrapperHessianDerivBlobIntensity(type, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureIntensity<I, D> hessianDet() {
        return new WrapperHessianThreeImageDetIntensity();
    }

    public static <I extends ImageGray<I>> GeneralFeatureIntensity<I, ?> laplacian() {
        return new WrapperLaplacianBlobIntensity();
    }
}

