/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;

public class DetectDescribe_CompleteSift<I extends ImageGray<I>>
implements DetectDescribePoint<I, BrightFeature> {
    CompleteSift alg;
    GrayF32 imageFloat = new GrayF32(1, 1);
    ImageType<I> inputType;

    public DetectDescribe_CompleteSift(CompleteSift alg, Class<I> inputType) {
        this.alg = alg;
        this.inputType = ImageType.single(inputType);
    }

    @Override
    public BrightFeature createDescription() {
        return new BrightFeature(this.alg.getDescriptorLength());
    }

    @Override
    public BrightFeature getDescription(int index) {
        return ((BrightFeature[])this.alg.getDescriptions().data)[index];
    }

    @Override
    public ImageType<I> getInputType() {
        return this.inputType;
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    @Override
    public void detect(I input) {
        if (!this.inputType.getDataType().isInteger()) {
            this.alg.process((GrayF32)input);
        } else {
            this.imageFloat.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, (ImageBase)this.imageFloat);
            this.alg.process(this.imageFloat);
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.alg.getDescriptions().size;
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.alg.getLocations().get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return ((ScalePoint)((Object)this.alg.getLocations().get((int)featureIndex))).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.alg.getOrientations().get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

