/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class WrapFHtoInterestPoint<T extends ImageGray<T>, II extends ImageGray<II>>
implements InterestPointDetector<T> {
    FastHessianFeatureDetector<II> detector;
    List<ScalePoint> location;
    II integral;
    ImageType<T> inputType;

    public WrapFHtoInterestPoint(FastHessianFeatureDetector<II> detector, Class<T> inputType) {
        this.detector = detector;
        this.inputType = ImageType.single(inputType);
    }

    @Override
    public void detect(T input) {
        if (this.integral != null) {
            this.integral.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.integral = GIntegralImageOps.transform(input, this.integral);
        this.detector.detect(this.integral);
        this.location = this.detector.getFoundPoints();
    }

    @Override
    public int getNumberOfFeatures() {
        return this.location.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.location.get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.location.get((int)featureIndex).scale * 2.0;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

