/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.disparity;

import boofcv.abst.feature.disparity.WrapBaseBlockMatch;
import boofcv.alg.feature.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.misc.ImageNormalization;
import boofcv.alg.misc.NormalizeParameters;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DisparityBlockMatchCorrelation<T extends ImageGray<T>, D extends ImageGray<D>, TF extends ImageGray<TF>>
extends WrapBaseBlockMatch<T, TF, D> {
    TF adjustedLeft;
    TF adjustedRight;
    boolean normalizeInput = true;
    NormalizeParameters parameters = new NormalizeParameters();
    ImageType<T> inputType;

    public DisparityBlockMatchCorrelation(DisparityBlockMatchRowFormat<TF, D> alg, Class<T> inputType) {
        super(alg);
        this.inputType = ImageType.single(inputType);
        this.adjustedLeft = (ImageGray)alg.getInputType().createImage(1, 1);
        this.adjustedRight = (ImageGray)alg.getInputType().createImage(1, 1);
    }

    @Override
    public void _process(T imageLeft, T imageRight) {
        if (this.normalizeInput) {
            ImageNormalization.zeroMeanMaxOne(imageLeft, this.adjustedLeft, (NormalizeParameters)this.parameters);
            ImageNormalization.apply(imageRight, (NormalizeParameters)this.parameters, this.adjustedRight);
        } else {
            GConvertImage.convert(imageLeft, this.adjustedLeft);
            GConvertImage.convert(imageRight, this.adjustedRight);
        }
        this.alg.process(this.adjustedLeft, this.adjustedRight, this.disparity);
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    public TF getAdjustedLeft() {
        return this.adjustedLeft;
    }

    public TF getAdjustedRight() {
        return this.adjustedRight;
    }

    public boolean isNormalizeInput() {
        return this.normalizeInput;
    }

    public void setNormalizeInput(boolean normalizeInput) {
        this.normalizeInput = normalizeInput;
    }
}

