/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.feature.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;

public abstract class WrapBaseBlockMatch<In extends ImageGray<In>, T extends ImageGray<T>, DI extends ImageGray<DI>>
implements StereoDisparity<In, DI> {
    DisparityBlockMatchRowFormat<T, DI> alg;
    DI disparity;

    public WrapBaseBlockMatch(DisparityBlockMatchRowFormat<T, DI> alg) {
        this.alg = alg;
    }

    @Override
    public void process(In imageLeft, In imageRight) {
        if (this.disparity == null || ((ImageGray)this.disparity).width != ((ImageGray)imageLeft).width || ((ImageGray)this.disparity).height != ((ImageGray)imageLeft).height) {
            this.disparity = GeneralizedImageOps.createSingleBand(this.alg.getDisparityType(), (int)((ImageGray)imageLeft).width, (int)((ImageGray)imageLeft).height);
            GImageMiscOps.fill(this.disparity, (double)this.getInvalidValue());
        }
        this.disparity.reshape(imageLeft);
        this._process(imageLeft, imageRight);
    }

    protected abstract void _process(In var1, In var2);

    @Override
    public DI getDisparity() {
        return this.disparity;
    }

    @Override
    public int getBorderX() {
        return this.alg.getBorderX();
    }

    @Override
    public int getBorderY() {
        return this.alg.getBorderY();
    }

    @Override
    public int getDisparityMin() {
        return this.alg.getDisparityMin();
    }

    @Override
    public int getDisparityRange() {
        return this.alg.getDisparityMax() - this.alg.getDisparityMin();
    }

    @Override
    public int getInvalidValue() {
        return this.getDisparityRange();
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.alg.getDisparityType();
    }

    public DisparityBlockMatchRowFormat<T, DI> getAlg() {
        return this.alg;
    }
}

