/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.tracker.combined.CombinedTrack;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.ArrayList;
import java.util.List;

public class PointTrackerCombined<I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc>
implements PointTracker<I> {
    CombinedTrackerScalePoint<I, D, Desc> tracker;
    protected long frameID = -1L;
    PyramidDiscrete<I> pyramid;
    D[] derivX;
    D[] derivY;
    ImageType<D> derivType;
    ImageGradient<I, D> gradient;
    int reactivateThreshold;
    int previousSpawn;
    boolean detected;

    public PointTrackerCombined(CombinedTrackerScalePoint<I, D, Desc> tracker, ConfigDiscreteLevels configLevels, int reactivateThreshold, Class<I> imageType, Class<D> derivType) {
        this.tracker = tracker;
        this.reactivateThreshold = reactivateThreshold;
        this.derivType = ImageType.single(derivType);
        this.pyramid = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)configLevels, (double)-1.0, (int)2, (boolean)true, (ImageType)ImageType.single(imageType));
        this.gradient = FactoryDerivative.sobel(imageType, derivType);
        this.reset();
    }

    @Override
    public void reset() {
        this.tracker.reset();
        this.previousSpawn = 0;
        this.detected = false;
        this.frameID = -1L;
    }

    @Override
    public long getFrameID() {
        return this.frameID;
    }

    @Override
    public int getTotalActive() {
        return this.tracker.getReactivated().size() + this.tracker.getPureKlt().size();
    }

    @Override
    public int getTotalInactive() {
        return this.tracker.getDormant().size();
    }

    @Override
    public void process(I image) {
        ++this.frameID;
        this.detected = false;
        this.pyramid.process(image);
        if (this.derivX == null) {
            this.derivX = PyramidOps.declareOutput(this.pyramid, this.derivType);
            this.derivY = PyramidOps.declareOutput(this.pyramid, this.derivType);
        }
        PyramidOps.gradient(this.pyramid, this.gradient, this.derivX, this.derivY);
        this.tracker.updateTracks((ImageGray)image, (PyramidDiscrete)this.pyramid, (ImageGray[])this.derivX, (ImageGray[])this.derivY);
        int numActive = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
        if (this.previousSpawn - numActive > this.reactivateThreshold) {
            this.detected = true;
            this.tracker.associateAllToDetected();
            this.previousSpawn = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
        }
        for (CombinedTrack<Desc> t : this.tracker.getPureKlt()) {
            ((PointTrack)t.getCookie()).pixel.set(t.pixel);
        }
        for (CombinedTrack<Desc> t : this.tracker.getReactivated()) {
            ((PointTrack)t.getCookie()).pixel.set(t.pixel);
        }
    }

    @Override
    public void spawnTracks() {
        if (!this.detected) {
            this.tracker.associateAllToDetected();
        }
        this.tracker.spawnTracksFromDetected();
        List<CombinedTrack<Desc>> spawned = this.tracker.getSpawned();
        for (CombinedTrack<Desc> t : spawned) {
            PointTrack p = (PointTrack)t.getCookie();
            if (p == null) {
                p = new PointTrack();
                t.setCookie(p);
            }
            p.pixel.set(t.pixel);
            p.setDescription(t);
            p.featureId = t.featureId;
            p.spawnFrameID = this.frameID;
        }
        this.previousSpawn = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
    }

    @Override
    public void dropAllTracks() {
        this.tracker.dropAllTracks();
    }

    @Override
    public int getMaxSpawn() {
        return 0;
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (this.tracker.dropTrack((CombinedTrack)track.getDescription())) {
            --this.previousSpawn;
            return true;
        }
        return false;
    }

    @Override
    public void dropTracks(PointTracker.Dropper dropper) {
        this.dropTracks(dropper, this.tracker.getPureKlt());
        this.dropTracks(dropper, this.tracker.getReactivated());
        this.dropTracks(dropper, this.tracker.getDormant());
    }

    private void dropTracks(PointTracker.Dropper dropper, List<CombinedTrack<Desc>> tracks) {
        for (int i = tracks.size() - 1; i >= 0; --i) {
            PointTrack track = (PointTrack)tracks.get(i).getCookie();
            if (!dropper.shouldDropTrack(track)) continue;
            this.tracker.addUnused(tracks.remove(i));
            --this.previousSpawn;
        }
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getReactivated(), list);
        this.addToList(this.tracker.getPureKlt(), list);
        this.addToList(this.tracker.getDormant(), list);
        return list;
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getReactivated(), list);
        this.addToList(this.tracker.getPureKlt(), list);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getDormant(), list);
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getSpawned(), list);
        return list;
    }

    private void addToList(List<CombinedTrack<Desc>> in, List<PointTrack> out) {
        for (int i = 0; i < in.size(); ++i) {
            out.add((PointTrack)in.get(i).getCookie());
        }
    }
}

