/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.BackgroundAlgorithmGmm;
import boofcv.alg.background.BackgroundGmmCommon;
import boofcv.alg.background.BackgroundModelStationary;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import javax.annotation.Nullable;

public abstract class BackgroundStationaryGmm<T extends ImageBase<T>>
extends BackgroundModelStationary<T>
implements BackgroundAlgorithmGmm {
    BackgroundGmmCommon common;

    public BackgroundStationaryGmm(float learningPeriod, float decayCoef, int maxGaussians, ImageType<T> imageType) {
        super(imageType);
        this.common = new BackgroundGmmCommon(learningPeriod, decayCoef, maxGaussians, imageType);
    }

    @Override
    public void reset() {
        this.common.model.reshape(0, 0);
        this.common.imageHeight = 0;
        this.common.imageWidth = 0;
    }

    @Override
    public void updateBackground(T frame) {
        this.updateBackground(frame, null);
    }

    @Override
    public void updateBackground(T frame, @Nullable GrayU8 mask) {
        if (this.common.imageWidth != ((ImageBase)frame).width || this.common.imageHeight != ((ImageBase)frame).height) {
            this.common.imageWidth = ((ImageBase)frame).width;
            this.common.imageHeight = ((ImageBase)frame).height;
            this.common.model.reshape(((ImageBase)frame).height, ((ImageBase)frame).width * this.common.modelStride);
            this.common.model.zero();
        }
        if (mask != null) {
            mask.reshape(((ImageBase)frame).width, ((ImageBase)frame).height);
        }
    }

    @Override
    public float getInitialVariance() {
        return this.common.initialVariance;
    }

    @Override
    public void setInitialVariance(float initialVariance) {
        this.common.initialVariance = initialVariance;
    }

    @Override
    public float getLearningPeriod() {
        return 1.0f / this.common.learningRate;
    }

    @Override
    public void setLearningPeriod(float period) {
        this.common.learningRate = 1.0f / period;
    }

    @Override
    public void setSignificantWeight(float value) {
        this.common.significantWeight = value;
    }

    public float getMaxDistance() {
        return this.common.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.common.maxDistance = maxDistance;
    }
}

