/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;

public class GeneralFeatureDetector<I extends ImageGray<I>, D extends ImageGray<D>> {
    protected QueueCorner foundMaximum = new QueueCorner(10);
    protected QueueCorner foundMinimum = new QueueCorner(10);
    protected QueueCorner excludeMaximum;
    protected QueueCorner excludeMinimum;
    protected FeatureSelectLimit selectMax;
    protected QueueCorner selected = new QueueCorner();
    protected int maxFeatures;
    protected NonMaxSuppression extractor;
    protected GeneralFeatureIntensity<I, D> intensity;

    public GeneralFeatureDetector(GeneralFeatureIntensity<I, D> intensity, NonMaxSuppression extractor, FeatureSelectLimit selectMax) {
        if (extractor.canDetectMinimums() && !intensity.localMinimums()) {
            throw new IllegalArgumentException("Extracting local minimums, but intensity has minimums set to false");
        }
        if (extractor.canDetectMaximums() && !intensity.localMaximums()) {
            throw new IllegalArgumentException("Extracting local maximums, but intensity has maximums set to false");
        }
        if (extractor.getUsesCandidates() && !intensity.hasCandidates()) {
            throw new IllegalArgumentException("The extractor requires candidate features, which the intensity does not provide.");
        }
        this.intensity = intensity;
        this.extractor = extractor;
        this.selectMax = selectMax;
        if (intensity.getIgnoreBorder() > extractor.getIgnoreBorder()) {
            extractor.setIgnoreBorder(intensity.getIgnoreBorder());
        }
    }

    protected GeneralFeatureDetector() {
    }

    public void process(I image, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        Point2D_I16 p;
        int i;
        this.intensity.process(image, derivX, derivY, derivXX, derivYY, derivXY);
        GrayF32 intensityImage = this.intensity.getIntensity();
        int numSelectMin = -1;
        int numSelectMax = -1;
        if (this.maxFeatures > 0) {
            if (this.intensity.localMinimums()) {
                int n = numSelectMin = this.excludeMinimum == null ? this.maxFeatures : this.maxFeatures - this.excludeMinimum.size;
            }
            if (this.intensity.localMaximums()) {
                int n = numSelectMax = this.excludeMaximum == null ? this.maxFeatures : this.maxFeatures - this.excludeMaximum.size;
            }
            if (numSelectMin <= 0 && numSelectMax <= 0) {
                return;
            }
        }
        if (this.excludeMinimum != null) {
            for (i = 0; i < this.excludeMinimum.size; ++i) {
                p = (Point2D_I16)this.excludeMinimum.get(i);
                intensityImage.set((int)p.x, (int)p.y, -3.4028235E38f);
            }
        }
        if (this.excludeMaximum != null) {
            for (i = 0; i < this.excludeMaximum.size; ++i) {
                p = (Point2D_I16)this.excludeMaximum.get(i);
                intensityImage.set((int)p.x, (int)p.y, Float.MAX_VALUE);
            }
        }
        this.foundMinimum.reset();
        this.foundMaximum.reset();
        if (this.intensity.hasCandidates()) {
            this.extractor.process(intensityImage, this.intensity.getCandidatesMin(), this.intensity.getCandidatesMax(), this.foundMinimum, this.foundMaximum);
        } else {
            this.extractor.process(intensityImage, null, null, this.foundMinimum, this.foundMaximum);
        }
        this.resolveSelectAmbiguity(intensityImage, this.excludeMaximum, this.foundMinimum, numSelectMin, false);
        this.resolveSelectAmbiguity(intensityImage, this.excludeMinimum, this.foundMaximum, numSelectMax, true);
    }

    private void resolveSelectAmbiguity(GrayF32 intensity, QueueCorner excluded, QueueCorner detected, int numSelect, boolean positive) {
        if (numSelect > 0) {
            this.selectMax.select(intensity, positive, (FastAccess<Point2D_I16>)excluded, (FastAccess<Point2D_I16>)detected, numSelect, (FastQueue<Point2D_I16>)this.selected);
            detected.reset();
            detected.appendAll(this.selected);
        }
    }

    public boolean getRequiresGradient() {
        return this.intensity.getRequiresGradient();
    }

    public boolean getRequiresHessian() {
        return this.intensity.getRequiresHessian();
    }

    public GrayF32 getIntensity() {
        return this.intensity.getIntensity();
    }

    public void setThreshold(float threshold) {
        this.extractor.setThresholdMaximum(threshold);
    }

    public float getThreshold() {
        return this.extractor.getThresholdMaximum();
    }

    public void setExcludeMaximum(QueueCorner exclude) {
        this.excludeMaximum = exclude;
    }

    public QueueCorner getMaximums() {
        return this.foundMaximum;
    }

    public void setExcludeMinimum(QueueCorner exclude) {
        this.excludeMinimum = exclude;
    }

    public QueueCorner getMinimums() {
        return this.foundMinimum;
    }

    public boolean isDetectMinimums() {
        return this.intensity.localMinimums();
    }

    public boolean isDetectMaximums() {
        return this.intensity.localMaximums();
    }

    public void setSearchRadius(int radius) {
        this.extractor.setSearchRadius(radius);
    }

    public int getSearchRadius() {
        return this.extractor.getSearchRadius();
    }

    public Class<I> getImageType() {
        return this.intensity.getImageType();
    }

    public Class<D> getDerivType() {
        return this.intensity.getDerivType();
    }

    public FeatureSelectLimit getSelectMax() {
        return this.selectMax;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public NonMaxSuppression getExtractor() {
        return this.extractor;
    }
}

