/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.alg.feature.detect.line.HoughTransformParameters;
import boofcv.struct.feature.CachedSineCosine_F32;
import boofcv.struct.image.GrayF32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;

public class HoughParametersPolar
implements HoughTransformParameters {
    int originX;
    int originY;
    float r_max;
    CachedSineCosine_F32 tableTrig;
    int numBinsAngle;
    double rangeResolution;
    int numBinsRange;

    public HoughParametersPolar(double rangeResolution, int numBinsAngle) {
        this.rangeResolution = rangeResolution;
        this.numBinsAngle = numBinsAngle;
        this.tableTrig = new CachedSineCosine_F32(0.0f, (float)Math.PI, numBinsAngle);
    }

    @Override
    public void initialize(int width, int height, GrayF32 transform) {
        this.originX = width / 2;
        this.originY = height / 2;
        this.r_max = (float)Math.sqrt(this.originX * this.originX + this.originY * this.originY);
        this.numBinsRange = (int)Math.ceil((double)this.r_max / this.rangeResolution);
        transform.reshape(this.numBinsRange, this.numBinsAngle);
    }

    @Override
    public boolean isTransformValid(int x, int y) {
        return true;
    }

    @Override
    public void lineToCoordinate(LineParametric2D_F32 line, Point2D_F64 coordinate) {
        float px = line.p.x - (float)this.originX;
        float py = line.p.y - (float)this.originY;
        float top = line.slope.y * px - line.slope.x * py;
        float distance = top / line.slope.norm();
        float angle = (float)Math.atan2(-line.slope.x, line.slope.y);
        int w2 = this.numBinsRange / 2;
        coordinate.x = Math.round(distance * (float)w2 / this.r_max + (float)w2);
        coordinate.y = (double)(angle * (float)this.numBinsAngle) / Math.PI;
    }

    @Override
    public void transformToLine(float x, float y, LineParametric2D_F32 line) {
        int w2 = this.numBinsRange / 2;
        float r = this.r_max * (x - (float)w2) / (float)w2;
        float c = this.tableTrig.cosine(y);
        float s = this.tableTrig.sine(y);
        line.p.set(r * c + (float)this.originX, r * s + (float)this.originY);
        line.slope.set(-s, c);
    }

    @Override
    public void parameterize(int x, int y, GrayF32 transform) {
        x -= this.originX;
        y -= this.originY;
        int w2 = transform.width / 2;
        for (int i = 0; i < transform.height; ++i) {
            int index;
            double p = (float)x * this.tableTrig.c[i] + (float)y * this.tableTrig.s[i];
            int col = (int)Math.floor(p * (double)w2 / (double)this.r_max) + w2;
            int n = index = transform.startIndex + i * transform.stride + col;
            transform.data[n] = transform.data[n] + 1.0f;
        }
    }

    @Override
    public void parameterize(int x, int y, float derivX, float derivY, Point2D_F32 parameter) {
        float px = x - this.originX;
        float py = y - this.originY;
        float sx = -derivY;
        float sy = derivX;
        float top = sy * px - sx * py;
        float distance = top / (float)Math.sqrt(sx * sx + sy * sy);
        float angle = (float)Math.atan2(-sx, sy);
        if (distance < 0.0f) {
            distance = -distance;
            angle = UtilAngle.bound((float)(angle + (float)Math.PI));
        }
        if (angle < 0.0f) {
            distance = -distance;
            angle = UtilAngle.toHalfCircle((float)angle);
        }
        int w2 = this.numBinsRange / 2;
        parameter.x = distance * (float)w2 / this.r_max + (float)w2;
        double yy = angle * (float)this.numBinsAngle;
        if (yy >= 1.0) {
            yy -= 1.0;
        }
        parameter.y = (float)(yy / Math.PI);
    }
}

