/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.line.HoughTransformGradient;
import boofcv.alg.feature.detect.line.HoughTransformParameters;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class HoughTransformGradient_MT<D extends ImageGray<D>>
extends HoughTransformGradient<D> {
    private final FastQueue<QueueCorner> blockCandidates = new FastQueue(QueueCorner::new);

    public HoughTransformGradient_MT(NonMaxSuppression extractor, HoughTransformParameters parameters, Class<D> derivType) {
        super(extractor, parameters, derivType);
    }

    @Override
    void transform(GrayU8 binary) {
        this.blockCandidates.reset();
        BoofConcurrency.loopBlocks((int)0, (int)binary.height, this.blockCandidates, (storage, y0, y1) -> {
            storage.reset();
            for (int y = y0; y < y1; ++y) {
                int start = binary.startIndex + y * binary.stride;
                int end = start + binary.width;
                for (int index = start; index < end; ++index) {
                    if (binary.data[index] == 0) continue;
                    int x = index - start;
                    this.parameterize((QueueCorner)storage, x, y, this._derivX.unsafe_getF(x, y), this._derivY.unsafe_getF(x, y));
                }
            }
        });
        this.candidates.reset();
        for (int i = 0; i < this.blockCandidates.size; ++i) {
            QueueCorner s = (QueueCorner)this.blockCandidates.get(i);
            for (int j = 0; j < s.size; ++j) {
                ((Point2D_I16)this.candidates.grow()).set((Point2D_I16)s.get(j));
            }
        }
    }
}

