/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import java.util.Random;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class FeatureSelectRandom
implements FeatureSelectLimit {
    final Random rand;
    private GrowQueue_I32 indexes = new GrowQueue_I32();

    public FeatureSelectRandom(long seed) {
        this.rand = new Random(seed);
    }

    @Override
    public void select(GrayF32 intensity, boolean positive, FastAccess<Point2D_I16> prior, FastAccess<Point2D_I16> detected, int limit, FastQueue<Point2D_I16> selected) {
        int i;
        selected.reset();
        if (detected.size <= limit) {
            BoofMiscOps.copyAll_2D_I16(detected, selected);
            return;
        }
        this.indexes.resize(detected.size);
        for (i = 0; i < detected.size; ++i) {
            this.indexes.data[i] = i;
        }
        for (i = 0; i < limit; ++i) {
            int idx = this.rand.nextInt(this.indexes.size - i);
            ((Point2D_I16)selected.grow()).set(((Point2D_I16[])detected.data)[this.indexes.data[idx]]);
            this.indexes.data[idx] = this.indexes.data[this.indexes.size - i - 1];
        }
    }
}

