/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.disparity.block.score.DisparitySparseRectifiedScoreBM;
import boofcv.alg.misc.GPixelMath;
import boofcv.alg.misc.ImageNormalization;
import boofcv.alg.misc.NormalizeParameters;
import boofcv.core.image.GConvertImage;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.ejml.UtilEjml;

public class SparseScoreRectifiedNcc<T extends ImageGray<T>>
extends DisparitySparseRectifiedScoreBM<float[], T> {
    public final SparseStatistics statsLeft = new SparseStatistics();
    public final SparseStatistics statsRight = new SparseStatistics();
    private final BlurStorageFilter<GrayF32> meanFilter;
    public float eps = UtilEjml.F_EPS;
    private final GrayF32 adjustedLeft = new GrayF32(1, 1);
    private final GrayF32 adjustedRight = new GrayF32(1, 1);
    public boolean normalizeInput = true;
    NormalizeParameters parameters = new NormalizeParameters();
    protected float[] scoreLtoR;
    protected float[] scoreRtoL;

    public SparseScoreRectifiedNcc(int blockRadiusX, int blockRadiusY, Class<T> imageType) {
        super(blockRadiusX, blockRadiusY, imageType);
        super.setSampleRegion(0, 0);
        this.meanFilter = FactoryBlurFilter.meanB((ImageType)ImageType.SB_F32, (int)blockRadiusX, (int)blockRadiusY, null);
    }

    @Override
    public void configure(int disparityMin, int disparityRange) {
        super.configure(disparityMin, disparityRange);
        this.scoreLtoR = new float[disparityRange];
        this.scoreRtoL = new float[disparityRange];
    }

    @Override
    protected void scoreDisparity(int disparityRange, boolean leftToRight) {
        if (this.normalizeInput) {
            ImageNormalization.zeroMeanMaxOne((ImageGray)this.patchCompare, (ImageGray)this.adjustedRight, (NormalizeParameters)this.parameters);
            ImageNormalization.apply((ImageGray)this.patchTemplate, (NormalizeParameters)this.parameters, (ImageGray)this.adjustedLeft);
        } else {
            GConvertImage.convert((ImageBase)this.patchTemplate, (ImageBase)this.adjustedLeft);
            GConvertImage.convert((ImageBase)this.patchCompare, (ImageBase)this.adjustedRight);
        }
        this.computeStats(this.adjustedLeft, this.statsLeft);
        this.computeStats(this.adjustedRight, this.statsRight);
        float[] dataLeft = this.adjustedLeft.data;
        float[] dataRight = this.adjustedRight.data;
        int rx = this.radiusX;
        int ry = this.radiusY;
        float meanL = this.statsLeft.mean.unsafe_get(rx, ry);
        float meanP2L = this.statsLeft.pow2mean.unsafe_get(rx, ry);
        float sigmaL = (float)Math.sqrt(Math.max(0.0f, meanP2L - meanL * meanL));
        float area = this.blockWidth * this.blockHeight;
        float[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
        for (int d = 0; d < disparityRange; ++d) {
            float meanR = this.statsRight.mean.unsafe_get(rx + d, ry);
            float meanP2R = this.statsRight.pow2mean.unsafe_get(rx + d, ry);
            float sigmaR = (float)Math.sqrt(Math.max(0.0f, meanP2R - meanR * meanR));
            float correlation = 0.0f;
            for (int y = 0; y < this.blockHeight; ++y) {
                int idxLeft = (y + this.sampleRadiusY) * this.adjustedLeft.stride + this.sampleRadiusX;
                int idxRight = (y + this.sampleRadiusY) * this.adjustedRight.stride + this.sampleRadiusX + d;
                for (int x = 0; x < this.blockWidth; ++x) {
                    correlation += dataLeft[idxLeft++] * dataRight[idxRight++];
                }
            }
            int index = leftToRight ? disparityRange - d - 1 : d;
            scores[index] = ((correlation /= area) - meanL * meanR) / (this.eps + sigmaL * sigmaR);
        }
    }

    private void computeStats(GrayF32 input, SparseStatistics stats) {
        this.meanFilter.process((ImageBase)input, (ImageBase)stats.mean);
        GPixelMath.pow2((ImageBase)input, (ImageBase)stats.pow2);
        this.meanFilter.process((ImageBase)stats.pow2, (ImageBase)stats.pow2mean);
    }

    @Override
    public float[] getScoreLtoR() {
        return this.scoreLtoR;
    }

    @Override
    public float[] getScoreRtoL() {
        return this.scoreRtoL;
    }

    private static class SparseStatistics {
        final GrayF32 mean = new GrayF32(1, 1);
        final GrayF32 pow2mean = new GrayF32(1, 1);
        final GrayF32 pow2 = new GrayF32(1, 1);

        private SparseStatistics() {
        }
    }
}

