/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.alg.feature.orientation.OrientationHistogram;
import boofcv.struct.image.GrayS16;

public class ImplOrientationHistogram_S16
extends OrientationHistogram<GrayS16> {
    public ImplOrientationHistogram_S16(double objectToSample, int numAngles, boolean isWeighted) {
        super(objectToSample, numAngles, isWeighted);
    }

    @Override
    public Class<GrayS16> getImageType() {
        return GrayS16.class;
    }

    @Override
    protected void computeUnweightedScore() {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayS16)this.derivX).startIndex + ((GrayS16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayS16)this.derivY).startIndex + ((GrayS16)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                short dx = ((GrayS16)this.derivX).data[indexX];
                short dy = ((GrayS16)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)dx;
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)dy;
                ++x;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void computeWeightedScore(int c_x, int c_y) {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayS16)this.derivX).startIndex + ((GrayS16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayS16)this.derivY).startIndex + ((GrayS16)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                float w = this.weights.data[indexW];
                short dx = ((GrayS16)this.derivX).data[indexX];
                short dy = ((GrayS16)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)(w * (float)dx);
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)(w * (float)dy);
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
    }

    @Override
    public RegionOrientation copy() {
        ImplOrientationHistogram_S16 copy = new ImplOrientationHistogram_S16(this.objectToSample, this.numAngles, this.isWeighted);
        copy.setObjectToSample(this.objectToSample);
        return copy;
    }
}

