/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import java.util.Arrays;

public class DenseOpticalFlowKlt<I extends ImageGray<I>, D extends ImageGray<D>> {
    private static float MAGIC_ADJUSTMENT = 0.7f;
    private PyramidKltTracker<I, D> tracker;
    private PyramidKltFeature feature;
    float[] scores = new float[1];
    private int regionRadius;
    private int width;
    private int height;

    public DenseOpticalFlowKlt(PyramidKltTracker<I, D> tracker, int radius) {
        this.tracker = tracker;
        this.regionRadius = radius;
    }

    public void process(ImagePyramid<I> prev, D[] prevDerivX, D[] prevDerivY, ImagePyramid<I> curr, ImageFlow output) {
        if (this.feature == null) {
            this.feature = new PyramidKltFeature(prev.getNumLayers(), this.regionRadius);
        }
        this.width = output.width;
        this.height = output.height;
        int N = this.width * this.height;
        if (this.scores.length < N) {
            this.scores = new float[N];
        }
        Arrays.fill(this.scores, 0, N, Float.MAX_VALUE);
        for (int i = 0; i < N; ++i) {
            output.data[i].markInvalid();
        }
        for (int y = 0; y < output.height; ++y) {
            for (int x = 0; x < output.width; ++x) {
                this.tracker.setImage((ImagePyramid)prev, (ImageGray[])prevDerivX, (ImageGray[])prevDerivY);
                this.feature.setPosition(x, y);
                if (!this.tracker.setDescription(this.feature)) continue;
                this.tracker.setImage(curr);
                KltTrackFault fault = this.tracker.track(this.feature);
                if (fault != KltTrackFault.SUCCESS) continue;
                float score = this.tracker.getError();
                this.scores[y * output.width + x] = score * MAGIC_ADJUSTMENT;
                output.get(x, y).set(this.feature.x - (float)x, this.feature.y - (float)y);
                this.checkNeighbors(x, y, score, this.feature.x - (float)x, this.feature.y - (float)y, output);
            }
        }
    }

    protected void checkNeighbors(int cx, int cy, float score, float flowX, float flowY, ImageFlow output) {
        int x0 = Math.max(0, cx - this.regionRadius);
        int x1 = Math.min(output.width, cx + this.regionRadius + 1);
        int y0 = Math.max(0, cy - this.regionRadius);
        int y1 = Math.min(output.height, cy + this.regionRadius + 1);
        for (int i = y0; i < y1; ++i) {
            int index = this.width * i + x0;
            int j = x0;
            while (j < x1) {
                float m0;
                float m1;
                float s = this.scores[index];
                ImageFlow.D f = output.data[index];
                if (s > score) {
                    f.set(flowX, flowY);
                    this.scores[index] = score;
                } else if (s == score && (m1 = flowX * flowX + flowY * flowY) < (m0 = f.x * f.x + f.y * f.y)) {
                    f.set(flowX, flowY);
                    this.scores[index] = score;
                }
                ++j;
                ++index;
            }
        }
    }
}

