/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.fh04.impl;

import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import org.ddogleg.struct.FastQueue;

public class FhEdgeWeights4_PLF32
implements FhEdgeWeights<Planar<GrayF32>> {
    float[] pixelColor = new float[1];

    @Override
    public void process(Planar<GrayF32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int y;
        if (this.pixelColor.length != input.getNumBands()) {
            this.pixelColor = new float[input.getNumBands()];
        }
        int numBands = this.pixelColor.length;
        edges.reset();
        int w = input.width - 1;
        int h = input.height - 1;
        for (y = 0; y < h; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 0;
            int indexDst = y * input.width + 0;
            int x = 0;
            while (x < w) {
                float weight1 = 0.0f;
                float weight2 = 0.0f;
                for (int i = 0; i < numBands; ++i) {
                    GrayF32 band = (GrayF32)input.getBand(i);
                    float color0 = band.data[indexSrc];
                    float color1 = band.data[indexSrc + 1];
                    float color2 = band.data[indexSrc + input.stride];
                    float diff1 = color0 - color1;
                    float diff2 = color0 - color2;
                    weight1 += diff1 * diff1;
                    weight2 += diff2 * diff2;
                }
                SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                SegmentFelzenszwalbHuttenlocher04.Edge e2 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                e1.sortValue = (float)Math.sqrt(weight1);
                e1.indexA = indexDst;
                e1.indexB = indexDst + 1;
                e2.sortValue = (float)Math.sqrt(weight2);
                e2.indexA = indexDst;
                e2.indexB = indexDst + input.width;
                ++x;
                ++indexSrc;
                ++indexDst;
            }
        }
        for (y = 0; y < h; ++y) {
            this.checkAround(w, y, input, edges);
        }
        for (int x = 0; x < w; ++x) {
            this.checkAround(x, h, input, edges);
        }
    }

    private void checkAround(int x, int y, Planar<GrayF32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexA = y * input.width + x;
        int numBands = this.pixelColor.length;
        for (int i = 0; i < numBands; ++i) {
            GrayF32 band = (GrayF32)input.getBand(i);
            this.pixelColor[i] = band.data[indexSrc];
        }
        this.check(x + 1, y, this.pixelColor, indexA, input, edges);
        this.check(x, y + 1, this.pixelColor, indexA, input, edges);
    }

    private void check(int x, int y, float[] color0, int indexA, Planar<GrayF32> input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        if (!input.isInBounds(x, y)) {
            return;
        }
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexB = y * input.width + x;
        float weight = 0.0f;
        int numBands = this.pixelColor.length;
        for (int i = 0; i < numBands; ++i) {
            GrayF32 band = (GrayF32)input.getBand(i);
            float color = band.data[indexSrc];
            float diff = color0[i] - color;
            weight += diff * diff;
        }
        SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
        e1.sortValue = (float)Math.sqrt(weight);
        e1.indexA = indexA;
        e1.indexB = indexB;
    }

    @Override
    public ImageType<Planar<GrayF32>> getInputType() {
        return ImageType.pl((int)3, GrayF32.class);
    }
}

