/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.struct.image.ImageGray;
import georegression.fitting.line.FitLine_F64;
import georegression.geometry.UtilLine2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class SnapToLineEdge<T extends ImageGray<T>>
extends BaseIntegralEdge<T> {
    protected int lineSamples;
    protected int radialSamples;
    private LinePolar2D_F64 polar = new LinePolar2D_F64();
    protected GrowQueue_F64 weights = new GrowQueue_F64();
    protected FastQueue<Point2D_F64> samplePts = new FastQueue(Point2D_F64::new);
    protected Point2D_F64 center = new Point2D_F64();
    protected double localScale;

    public SnapToLineEdge(int lineSamples, int tangentialSamples, Class<T> imageType) {
        super(imageType);
        if (tangentialSamples < 1) {
            throw new IllegalArgumentException("Tangential samples must be >= 1 or else it won't work");
        }
        this.lineSamples = lineSamples;
        this.radialSamples = tangentialSamples;
    }

    public boolean refine(Point2D_F64 a, Point2D_F64 b, LineGeneral2D_F64 found) {
        this.center.x = (a.x + b.x) / 2.0;
        this.center.y = (a.y + b.y) / 2.0;
        this.localScale = a.distance((GeoTuple2D_F64)this.center);
        double slopeX = b.x - a.x;
        double slopeY = b.y - a.y;
        double r = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        double tanX = slopeY / r;
        double tanY = -slopeX / r;
        this.computePointsAndWeights(slopeX, slopeY, a.x, a.y, tanX, tanY);
        if (this.samplePts.size() >= 4) {
            if (null == FitLine_F64.polar((List)this.samplePts.toList(), (double[])this.weights.data, (LinePolar2D_F64)this.polar)) {
                throw new RuntimeException("All weights were zero, bug some place");
            }
            UtilLine2D_F64.convert((LinePolar2D_F64)this.polar, (LineGeneral2D_F64)found);
            this.localToGlobal(found);
            return true;
        }
        return false;
    }

    protected void computePointsAndWeights(double slopeX, double slopeY, double x0, double y0, double tanX, double tanY) {
        this.samplePts.reset();
        this.weights.reset();
        int numSamples = this.radialSamples * 2 + 2;
        int numPts = numSamples - 1;
        double widthX = (double)numSamples * tanX;
        double widthY = (double)numSamples * tanY;
        for (int i = 0; i < this.lineSamples; ++i) {
            double frac = (double)i / (double)(this.lineSamples - 1);
            double x = x0 + slopeX * frac - widthX / 2.0;
            double y = y0 + slopeY * frac - widthY / 2.0;
            if (!this.integral.isInside(x, y) || !this.integral.isInside(x + widthX, y + widthY)) continue;
            double sample0 = this.integral.compute(x, y, x + tanX, y + tanY);
            x += tanX;
            y += tanY;
            for (int j = 0; j < numPts && (j != numPts - 1 || this.integral.isInside(x + tanX, y + tanY)); ++j) {
                double sample1 = this.integral.compute(x, y, x + tanX, y + tanY);
                double w = sample0 - sample1;
                if (w < 0.0) {
                    w = -w;
                }
                if (w > 0.0) {
                    this.weights.add(w);
                    ((Point2D_F64)this.samplePts.grow()).set((x - this.center.x) / this.localScale, (y - this.center.y) / this.localScale);
                }
                x += tanX;
                y += tanY;
                sample0 = sample1;
            }
        }
    }

    protected void localToGlobal(LineGeneral2D_F64 line) {
        line.C = this.localScale * line.C - this.center.x * line.A - this.center.y * line.B;
    }

    public int getLineSamples() {
        return this.lineSamples;
    }

    public void setLineSamples(int lineSamples) {
        this.lineSamples = lineSamples;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public void setRadialSamples(int radialSamples) {
        this.radialSamples = radialSamples;
    }

    public Class<T> getImageType() {
        return this.imageType;
    }

    public void setImageType(Class<T> imageType) {
        this.imageType = imageType;
    }
}

