/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import georegression.fitting.line.FitLine_I32;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class RefinePolygonToContour {
    private List<Point2D_I32> work = new ArrayList<Point2D_I32>();
    private LinePolar2D_F64 polar = new LinePolar2D_F64();
    private FastQueue<LineGeneral2D_F64> lines = new FastQueue(LineGeneral2D_F64::new);

    public void process(List<Point2D_I32> contour, GrowQueue_I32 vertexes, Polygon2D_F64 output) {
        int numDecreasing = 0;
        int i = vertexes.size - 1;
        int j = 0;
        while (j < vertexes.size) {
            if (vertexes.get(i) > vertexes.get(j)) {
                ++numDecreasing;
            }
            i = j++;
        }
        boolean decreasing = numDecreasing > 1;
        output.vertexes.resize(vertexes.size);
        this.lines.resize(vertexes.size);
        int i2 = vertexes.size - 1;
        int j2 = 0;
        while (j2 < vertexes.size) {
            int idx0 = vertexes.get(i2);
            int idx1 = vertexes.get(j2);
            if (decreasing) {
                int tmp = idx0;
                idx0 = idx1;
                idx1 = tmp;
            }
            if (idx0 > idx1) {
                int k;
                this.work.clear();
                for (k = idx0; k < contour.size(); ++k) {
                    this.work.add(contour.get(k));
                }
                for (k = 0; k < idx1; ++k) {
                    this.work.add(contour.get(k));
                }
                FitLine_I32.polar(this.work, (int)0, (int)this.work.size(), (LinePolar2D_F64)this.polar);
            } else {
                FitLine_I32.polar(contour, (int)idx0, (int)(idx1 - idx0), (LinePolar2D_F64)this.polar);
            }
            UtilLine2D_F64.convert((LinePolar2D_F64)this.polar, (LineGeneral2D_F64)((LineGeneral2D_F64)this.lines.get(i2)));
            i2 = j2++;
        }
        i2 = vertexes.size - 1;
        j2 = 0;
        while (j2 < vertexes.size) {
            LineGeneral2D_F64 lineA = (LineGeneral2D_F64)this.lines.get(i2);
            LineGeneral2D_F64 lineB = (LineGeneral2D_F64)this.lines.get(j2);
            Intersection2D_F64.intersection((LineGeneral2D_F64)lineA, (LineGeneral2D_F64)lineB, (Point2D_F64)output.get(j2));
            i2 = j2++;
        }
    }
}

