/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.ConfigTemplateDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.DescribeRegionPoint_SIFT;
import boofcv.abst.feature.describe.SurfPlanar_to_DescribeRegionPoint;
import boofcv.abst.feature.describe.WrapDescribeBrief;
import boofcv.abst.feature.describe.WrapDescribeBriefSo;
import boofcv.abst.feature.describe.WrapDescribePixelRegion;
import boofcv.abst.feature.describe.WrapDescribePixelRegionNCC;
import boofcv.abst.feature.describe.WrapDescribeSurf;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.describe.ConfigDescribeRegionPoint;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import java.util.Random;
import javax.annotation.Nullable;

public class FactoryDescribeRegionPoint {
    public static <T extends ImageGray<T>, Desc extends TupleDesc> DescribeRegionPoint<T, Desc> generic(ConfigDescribeRegionPoint config, Class<T> imageType) {
        switch (config.type) {
            case SURF_FAST: {
                return FactoryDescribeRegionPoint.surfFast(config.surfFast, imageType);
            }
            case SURF_STABLE: {
                return FactoryDescribeRegionPoint.surfStable(config.surfStability, imageType);
            }
            case SIFT: {
                return FactoryDescribeRegionPoint.sift(config.scaleSpaceSift, config.sift, imageType);
            }
            case BRIEF: {
                return FactoryDescribeRegionPoint.brief(config.brief, imageType);
            }
            case TEMPLATE: {
                return FactoryDescribeRegionPoint.template(config.template, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown descriptor");
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeRegionPoint<T, BrightFeature> surfFast(@Nullable ConfigSurfDescribe.Fast config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurf alg = FactoryDescribePointAlgs.surfSpeed(config, integralType);
        return new WrapDescribeSurf(alg, imageType);
    }

    public static <T extends ImageMultiBand<T>, II extends ImageGray<II>> DescribeRegionPoint<T, BrightFeature> surfColorFast(@Nullable ConfigSurfDescribe.Fast config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurf alg = FactoryDescribePointAlgs.surfSpeed(config, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar color = FactoryDescribePointAlgs.surfColor(alg, imageType.getNumBands());
            return new SurfPlanar_to_DescribeRegionPoint(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeRegionPoint<T, BrightFeature> surfStable(@Nullable ConfigSurfDescribe.Stability config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurfMod alg = FactoryDescribePointAlgs.surfStability(config, integralType);
        return new WrapDescribeSurf(alg, imageType);
    }

    public static <T extends ImageBase<T>, II extends ImageGray<II>> DescribeRegionPoint<T, BrightFeature> surfColorStable(ConfigSurfDescribe.Stability config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurfMod alg = FactoryDescribePointAlgs.surfStability(config, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar color = FactoryDescribePointAlgs.surfColor(alg, imageType.getNumBands());
            return new SurfPlanar_to_DescribeRegionPoint(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageGray<T>> DescribeRegionPoint<T, TupleDesc_F64> sift(@Nullable ConfigSiftScaleSpace configSS, @Nullable ConfigSiftDescribe configDescribe, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        configSS.checkValidity();
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        DescribePointSift<GrayF32> alg = FactoryDescribePointAlgs.sift(configDescribe, GrayF32.class);
        return new DescribeRegionPoint_SIFT<T>(ss, alg, imageType);
    }

    public static <T extends ImageGray<T>> DescribeRegionPoint<T, TupleDesc_B> brief(@Nullable ConfigBrief config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigBrief();
        }
        config.checkValidity();
        BlurStorageFilter filter = FactoryBlurFilter.gaussian((ImageType)ImageType.single(imageType), (double)config.blurSigma, (int)config.blurRadius);
        BinaryCompareDefinition_I32 definition = FactoryBriefDefinition.gaussian2(new Random(123L), config.radius, config.numPoints);
        if (config.fixed) {
            return new WrapDescribeBrief(FactoryDescribePointAlgs.brief(definition, filter), imageType);
        }
        return new WrapDescribeBriefSo(FactoryDescribePointAlgs.briefso(definition, filter), imageType);
    }

    public static <T extends ImageGray<T>, D extends TupleDesc> DescribeRegionPoint<T, D> template(@Nullable ConfigTemplateDescribe config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigTemplateDescribe();
        }
        switch (config.type) {
            case PIXEL: {
                return new WrapDescribePixelRegion(FactoryDescribePointAlgs.pixelRegion(config.width, config.height, imageType), imageType);
            }
            case NCC: {
                return new WrapDescribePixelRegionNCC<T>(FactoryDescribePointAlgs.pixelRegionNCC(config.width, config.height, imageType), imageType);
            }
        }
        throw new IllegalArgumentException("Unknown template type " + (Object)((Object)config.type));
    }

    public static <T extends ImageGray<T>, D extends TupleDesc> DescribeRegionPoint<T, D> pixel(int regionWidth, int regionHeight, Class<T> imageType) {
        return new WrapDescribePixelRegion(FactoryDescribePointAlgs.pixelRegion(regionWidth, regionHeight, imageType), imageType);
    }

    public static <T extends ImageGray<T>> DescribeRegionPoint<T, NccFeature> pixelNCC(int regionWidth, int regionHeight, Class<T> imageType) {
        return new WrapDescribePixelRegionNCC<T>(FactoryDescribePointAlgs.pixelRegionNCC(regionWidth, regionHeight, imageType), imageType);
    }
}

