/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.disparity;

import boofcv.abst.feature.disparity.DisparityBlockMatchCorrelation;
import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.disparity.WrapDisparityBlockMatchCensus;
import boofcv.abst.feature.disparity.WrapDisparityBlockMatchRowFormat;
import boofcv.abst.feature.disparity.WrapDisparitySgm;
import boofcv.abst.feature.disparity.WrapDisparitySparseRectifiedBM;
import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.transform.census.FilterCensusTransform;
import boofcv.alg.feature.disparity.DisparityBlockMatch;
import boofcv.alg.feature.disparity.DisparityBlockMatchBestFive;
import boofcv.alg.feature.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.feature.disparity.block.BlockRowScore;
import boofcv.alg.feature.disparity.block.BlockRowScoreCensus;
import boofcv.alg.feature.disparity.block.BlockRowScoreNcc;
import boofcv.alg.feature.disparity.block.BlockRowScoreSad;
import boofcv.alg.feature.disparity.block.DisparitySelect;
import boofcv.alg.feature.disparity.block.DisparitySparseSelect;
import boofcv.alg.feature.disparity.block.SparseScoreRectifiedCensus;
import boofcv.alg.feature.disparity.block.SparseScoreRectifiedNcc;
import boofcv.alg.feature.disparity.block.SparseScoreRectifiedSad;
import boofcv.alg.feature.disparity.block.score.DisparityScoreBMBestFive_F32;
import boofcv.alg.feature.disparity.block.score.DisparityScoreBMBestFive_S32;
import boofcv.alg.feature.disparity.block.score.DisparityScoreBM_F32;
import boofcv.alg.feature.disparity.block.score.DisparityScoreBM_S32;
import boofcv.alg.feature.disparity.block.score.DisparitySparseRectifiedScoreBM;
import boofcv.alg.feature.disparity.block.select.SelectSparseCorrelationSubpixel;
import boofcv.alg.feature.disparity.block.select.SelectSparseCorrelationWithChecksWta_F32;
import boofcv.alg.feature.disparity.sgm.SgmStereoDisparity;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.feature.disparity.ConfigDisparityBM;
import boofcv.factory.feature.disparity.ConfigDisparityBMBest5;
import boofcv.factory.feature.disparity.ConfigDisparitySGM;
import boofcv.factory.feature.disparity.DisparityError;
import boofcv.factory.feature.disparity.FactoryStereoDisparityAlgs;
import boofcv.factory.transform.census.CensusVariants;
import boofcv.factory.transform.census.FactoryCensusTransform;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import javax.annotation.Nullable;

public class FactoryStereoDisparity {
    public static <T extends ImageGray<T>, DI extends ImageGray<DI>> StereoDisparity<T, DI> blockMatch(@Nullable ConfigDisparityBM config, Class<T> imageType, Class<DI> dispType) {
        if (config == null) {
            config = new ConfigDisparityBM();
        }
        config.checkValidity();
        if (config.subpixel) {
            if (dispType != GrayF32.class) {
                throw new IllegalArgumentException("With subpixel on, disparity image must be GrayF32");
            }
        } else if (dispType != GrayU8.class) {
            throw new IllegalArgumentException("With subpixel on, disparity image must be GrayU8");
        }
        double maxError = (double)((config.regionRadiusX * 2 + 1) * (config.regionRadiusY * 2 + 1)) * config.maxPerPixelError;
        switch (config.errorType) {
            case SAD: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, imageType, (int)maxError);
                BlockRowScore rowScore = FactoryStereoDisparity.createScoreRowSad(config, imageType);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBlockMatching(config, imageType, select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, rowScore.getImageType()));
                return new WrapDisparityBlockMatchRowFormat(alg);
            }
            case CENSUS: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, imageType, (int)maxError);
                FilterCensusTransform censusTran = FactoryCensusTransform.variant((CensusVariants)config.configCensus.variant, (boolean)true, imageType);
                BlockRowScore rowScore = FactoryStereoDisparity.createCensusRowScore(config, (FilterImageInterface)censusTran);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBlockMatching(config, censusTran.getOutputType().getImageClass(), select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, (ImageType)censusTran.getOutputType()));
                return new WrapDisparityBlockMatchCensus(censusTran, alg);
            }
            case NCC: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, GrayF32.class, (int)maxError);
                BlockRowScore rowScore = FactoryStereoDisparity.createScoreRowNcc(config, GrayF32.class);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBlockMatching(config, GrayF32.class, select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, rowScore.getImageType()));
                DisparityBlockMatchCorrelation ret = new DisparityBlockMatchCorrelation(alg, imageType);
                ret.setNormalizeInput(config.configNCC.normalizeInput);
                return ret;
            }
        }
        throw new IllegalArgumentException("Unsupported error type " + (Object)((Object)config.errorType));
    }

    public static BlockRowScore createCensusRowScore(ConfigDisparityBM config, FilterImageInterface censusTran) {
        BlockRowScore.ArrayS32 rowScore;
        Class censusType = censusTran.getOutputType().getImageClass();
        int bits = config.configCensus.variant.getBits();
        if (censusType == GrayU8.class) {
            rowScore = new BlockRowScoreCensus.U8(bits);
        } else if (censusType == GrayS32.class) {
            rowScore = new BlockRowScoreCensus.S32(bits);
        } else if (censusType == GrayS64.class) {
            rowScore = new BlockRowScoreCensus.S64(bits);
        } else {
            throw new IllegalArgumentException("Unsupported image type");
        }
        return rowScore;
    }

    public static <T extends ImageGray<T>> DisparitySelect createDisparitySelect(ConfigDisparityBM config, Class<T> imageType, int maxError) {
        DisparitySelect<Object[], Object> select;
        if (!GeneralizedImageOps.isFloatingPoint(imageType) || config.errorType == DisparityError.CENSUS) {
            if (config.errorType.isCorrelation()) {
                throw new IllegalArgumentException("Can't do correlation scores for integer image types");
            }
            select = config.subpixel ? FactoryStereoDisparityAlgs.selectDisparitySubpixel_S32(maxError, config.validateRtoL, config.texture) : FactoryStereoDisparityAlgs.selectDisparity_S32(maxError, config.validateRtoL, config.texture);
        } else if (imageType == GrayF32.class) {
            select = config.subpixel ? (config.errorType.isCorrelation() ? FactoryStereoDisparityAlgs.selectCorrelation_F32(config.validateRtoL, config.texture, true) : FactoryStereoDisparityAlgs.selectDisparitySubpixel_F32(maxError, config.validateRtoL, config.texture)) : (config.errorType.isCorrelation() ? FactoryStereoDisparityAlgs.selectCorrelation_F32(config.validateRtoL, config.texture, false) : FactoryStereoDisparityAlgs.selectDisparity_F32(maxError, config.validateRtoL, config.texture));
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
        return select;
    }

    public static <T extends ImageGray<T>, DI extends ImageGray<DI>> StereoDisparity<T, DI> blockMatchBest5(@Nullable ConfigDisparityBMBest5 config, Class<T> imageType, Class<DI> dispType) {
        if (config == null) {
            config = new ConfigDisparityBMBest5();
        }
        config.checkValidity();
        if (config.subpixel) {
            if (dispType != GrayF32.class) {
                throw new IllegalArgumentException("With subpixel on, disparity image must be GrayF32");
            }
        } else if (dispType != GrayU8.class) {
            throw new IllegalArgumentException("With subpixel on, disparity image must be GrayU8");
        }
        double maxError = (double)((config.regionRadiusX * 2 + 1) * (config.regionRadiusY * 2 + 1)) * config.maxPerPixelError;
        maxError *= 3.0;
        switch (config.errorType) {
            case SAD: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, imageType, (int)maxError);
                BlockRowScore rowScore = FactoryStereoDisparity.createScoreRowSad(config, imageType);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBestFive(config, imageType, select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, rowScore.getImageType()));
                return new WrapDisparityBlockMatchRowFormat(alg);
            }
            case CENSUS: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, imageType, (int)maxError);
                FilterCensusTransform censusTran = FactoryCensusTransform.variant((CensusVariants)config.configCensus.variant, (boolean)true, imageType);
                BlockRowScore rowScore = FactoryStereoDisparity.createCensusRowScore(config, (FilterImageInterface)censusTran);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBestFive(config, censusTran.getOutputType().getImageClass(), select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, (ImageType)censusTran.getOutputType()));
                return new WrapDisparityBlockMatchCensus(censusTran, alg);
            }
            case NCC: {
                DisparitySelect select = FactoryStereoDisparity.createDisparitySelect(config, GrayF32.class, (int)maxError);
                BlockRowScore rowScore = FactoryStereoDisparity.createScoreRowNcc(config, GrayF32.class);
                DisparityBlockMatchRowFormat alg = FactoryStereoDisparity.createBestFive(config, GrayF32.class, select, rowScore);
                alg.setBorder(FactoryImageBorder.generic((BorderType)config.border, rowScore.getImageType()));
                return new DisparityBlockMatchCorrelation(alg, imageType);
            }
        }
        throw new IllegalArgumentException("Unsupported error type " + (Object)((Object)config.errorType));
    }

    public static <T extends ImageGray<T>> BlockRowScore createScoreRowSad(ConfigDisparityBM config, Class<T> imageType) {
        BlockRowScore<GrayU8, int[], byte[]> rowScore;
        if (imageType == GrayU8.class) {
            rowScore = new BlockRowScoreSad.U8();
        } else if (imageType == GrayU16.class) {
            rowScore = new BlockRowScoreSad.U16();
        } else if (imageType == GrayS16.class) {
            rowScore = new BlockRowScoreSad.S16();
        } else if (imageType == GrayF32.class) {
            rowScore = new BlockRowScoreSad.F32();
        } else {
            throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
        }
        return rowScore;
    }

    public static <T extends ImageGray<T>> BlockRowScore createScoreRowNcc(ConfigDisparityBM config, Class<T> imageType) {
        if (imageType != GrayF32.class) {
            throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
        }
        BlockRowScoreNcc.F32 rowScore = new BlockRowScoreNcc.F32(config.regionRadiusX, config.regionRadiusY);
        rowScore.eps = (float)config.configNCC.eps;
        return rowScore;
    }

    public static <T extends ImageGray<T>> DisparityBlockMatchRowFormat createBlockMatching(ConfigDisparityBM config, Class<T> imageType, DisparitySelect select, BlockRowScore rowScore) {
        DisparityBlockMatch alg = GeneralizedImageOps.isFloatingPoint(imageType) ? new DisparityScoreBM_F32(config.regionRadiusX, config.regionRadiusY, rowScore, select) : new DisparityScoreBM_S32(config.regionRadiusX, config.regionRadiusY, rowScore, select, ImageType.single(imageType));
        alg.configure(config.disparityMin, config.disparityRange);
        return alg;
    }

    public static <T extends ImageGray<T>> DisparityBlockMatchRowFormat createBestFive(ConfigDisparityBM config, Class<T> imageType, DisparitySelect select, BlockRowScore rowScore) {
        DisparityBlockMatchBestFive alg = GeneralizedImageOps.isFloatingPoint(imageType) ? new DisparityScoreBMBestFive_F32(config.regionRadiusX, config.regionRadiusY, rowScore, select) : new DisparityScoreBMBestFive_S32(config.regionRadiusX, config.regionRadiusY, rowScore, select, ImageType.single(imageType));
        alg.configure(config.disparityMin, config.disparityRange);
        return alg;
    }

    public static <T extends ImageGray<T>> StereoDisparitySparse<T> sparseRectifiedBM(ConfigDisparityBM config, Class<T> imageType) {
        double maxError = (double)((config.regionRadiusX * 2 + 1) * (config.regionRadiusY * 2 + 1)) * config.maxPerPixelError;
        DisparitySparseSelect<float[]> select = config.errorType == DisparityError.NCC ? (config.subpixel ? new SelectSparseCorrelationSubpixel.F32(config.texture, config.validateRtoL) : new SelectSparseCorrelationWithChecksWta_F32(config.texture, config.validateRtoL)) : (GeneralizedImageOps.isFloatingPoint(imageType) && config.errorType != DisparityError.CENSUS ? (config.subpixel ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_F32((int)maxError, config.texture, config.validateRtoL) : FactoryStereoDisparityAlgs.selectDisparitySparse_F32((int)maxError, config.texture, config.validateRtoL)) : (config.subpixel ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_S32((int)maxError, config.texture, config.validateRtoL) : FactoryStereoDisparityAlgs.selectDisparitySparse_S32((int)maxError, config.texture, config.validateRtoL)));
        DisparitySparseRectifiedScoreBM score = null;
        switch (config.errorType) {
            case SAD: {
                if (imageType == GrayU8.class) {
                    score = new SparseScoreRectifiedSad.U8(config.regionRadiusX, config.regionRadiusY);
                    break;
                }
                if (imageType == GrayF32.class) {
                    score = new SparseScoreRectifiedSad.F32(config.regionRadiusX, config.regionRadiusY);
                    break;
                }
                throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
            }
            case NCC: {
                SparseScoreRectifiedNcc<T> _score_ = new SparseScoreRectifiedNcc<T>(config.regionRadiusX, config.regionRadiusY, imageType);
                _score_.eps = (float)config.configNCC.eps;
                _score_.normalizeInput = config.configNCC.normalizeInput;
                score = _score_;
                break;
            }
            case CENSUS: {
                FilterCensusTransform censusTran = FactoryCensusTransform.variant((CensusVariants)config.configCensus.variant, (boolean)false, imageType);
                Class censusType = censusTran.getOutputType().getImageClass();
                if (censusType == GrayU8.class) {
                    score = new SparseScoreRectifiedCensus.U8<T>(config.regionRadiusX, config.regionRadiusY, censusTran, imageType);
                    break;
                }
                if (censusType == GrayS32.class) {
                    score = new SparseScoreRectifiedCensus.S32<T>(config.regionRadiusX, config.regionRadiusY, censusTran, imageType);
                    break;
                }
                if (censusType == GrayS64.class) {
                    score = new SparseScoreRectifiedCensus.S64<T>(config.regionRadiusX, config.regionRadiusY, censusTran, imageType);
                    break;
                }
                throw new RuntimeException("Image type not supported census: " + censusType.getSimpleName());
            }
        }
        if (score == null) {
            throw new RuntimeException("Selected score type and image type is not supported at this time");
        }
        ((DisparitySparseRectifiedScoreBM)score).configure(config.disparityMin, config.disparityRange);
        score.setBorder(FactoryImageBorder.generic((BorderType)config.border, (ImageType)ImageType.single(imageType)));
        return new WrapDisparitySparseRectifiedBM(score, select);
    }

    public static <T extends ImageGray<T>, DI extends ImageGray<DI>> StereoDisparity<T, DI> sgm(@Nullable ConfigDisparitySGM config, Class<T> imageType, Class<DI> dispType) {
        if (config == null) {
            config = new ConfigDisparitySGM();
        }
        if (config.subpixel) {
            if (dispType != GrayF32.class) {
                throw new IllegalArgumentException("Disparity must be F32 for sub-pixel precision");
            }
        } else if (dispType != GrayU8.class) {
            throw new IllegalArgumentException("Disparity must be U8 for pixel precision");
        }
        if (imageType == GrayU8.class) {
            SgmStereoDisparity alg = FactoryStereoDisparityAlgs.createSgm(config);
            return new WrapDisparitySgm(alg, config.subpixel);
        }
        throw new IllegalArgumentException("Only U8 input supported");
    }
}

