/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class SurfPlanar_to_DescribeRegionPoint<T extends ImageGray<T>, II extends ImageGray<II>>
implements DescribeRegionPoint<Planar<T>, BrightFeature> {
    DescribePointSurfPlanar<II> alg;
    T gray;
    II grayII;
    Planar<II> bandII;
    ImageType<Planar<T>> imageType;
    final double canonicalRadius;

    public SurfPlanar_to_DescribeRegionPoint(DescribePointSurfPlanar<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, (int)1, (int)1);
        this.bandII = new Planar(integralType, 1, 1, alg.getNumBands());
        this.imageType = ImageType.pl((int)alg.getNumBands(), imageType);
        this.canonicalRadius = (double)alg.getDescribe().getCanonicalWidth() / 2.0;
    }

    @Override
    public void setImage(Planar<T> image) {
        this.gray.reshape(image.width, image.height);
        this.grayII.reshape(image.width, image.height);
        this.bandII.reshape(image.width, image.height);
        GConvertImage.average(image, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < image.getNumBands(); ++i) {
            GIntegralImageOps.transform((ImageGray)image.getBand(i), (ImageGray)this.bandII.getBand(i));
        }
        this.alg.setImage(this.grayII, this.bandII);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, BrightFeature description) {
        double scale = radius / this.canonicalRadius;
        this.alg.describe(x, y, orientation, scale, description);
        return true;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public boolean isOriented() {
        return true;
    }

    @Override
    public ImageType<Planar<T>> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.alg.getDescribe().getCanonicalWidth();
    }

    @Override
    public BrightFeature createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }
}

