/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;

public class SurfPlanar_to_DetectDescribePoint<T extends ImageGray<T>, II extends ImageGray<II>>
implements DetectDescribePoint<Planar<T>, BrightFeature> {
    DetectDescribeSurfPlanar<II> alg;
    T gray;
    II grayII;
    Planar<II> bandII;
    ImageType<Planar<T>> inputType;

    public SurfPlanar_to_DetectDescribePoint(DetectDescribeSurfPlanar<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.inputType = ImageType.pl((int)alg.getDescribe().getNumBands(), imageType);
        this.gray = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, (int)1, (int)1);
        this.bandII = new Planar(integralType, 1, 1, alg.getDescribe().getNumBands());
    }

    @Override
    public void detect(Planar<T> input) {
        if (input.getNumBands() != this.bandII.getNumBands()) {
            throw new IllegalArgumentException("Unexpected number of bands. Expected " + this.bandII.getNumBands() + " found " + input.getNumBands());
        }
        this.gray.reshape(input.width, input.height);
        this.grayII.reshape(input.width, input.height);
        this.bandII.reshape(input.width, input.height);
        GConvertImage.average(input, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < input.getNumBands(); ++i) {
            GIntegralImageOps.transform((ImageGray)input.getBand(i), (ImageGray)this.bandII.getBand(i));
        }
        this.alg.detect(this.grayII, this.bandII);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }

    @Override
    public BrightFeature getDescription(int index) {
        return this.alg.getDescription(index);
    }

    @Override
    public ImageType<Planar<T>> getInputType() {
        return this.inputType;
    }

    @Override
    public BrightFeature createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.alg.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.alg.getLocation(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.alg.getRadius(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.alg.getOrientation(featureIndex);
    }
}

