/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.BaseGeneralFeatureIntensity;
import boofcv.alg.filter.derivative.DerivativeLaplacian;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class WrapperLaplacianBlobIntensity<I extends ImageGray<I>, D extends ImageGray<D>>
extends BaseGeneralFeatureIntensity<I, D> {
    public WrapperLaplacianBlobIntensity(Class<I> imageType) {
        super(imageType, null);
    }

    @Override
    public void process(I image, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        this.init(((ImageGray)image).width, ((ImageGray)image).height);
        if (image instanceof GrayU8) {
            DerivativeLaplacian.process((GrayU8)((GrayU8)image), (GrayF32)this.intensity);
        } else if (image instanceof GrayF32) {
            GImageDerivativeOps.laplace(image, (ImageGray)this.intensity, (BorderType)BorderType.SKIP);
        } else {
            throw new IllegalArgumentException("Unsupported input image type");
        }
    }

    @Override
    public QueueCorner getCandidatesMin() {
        return null;
    }

    @Override
    public QueueCorner getCandidatesMax() {
        return null;
    }

    @Override
    public boolean getRequiresGradient() {
        return false;
    }

    @Override
    public boolean getRequiresHessian() {
        return false;
    }

    @Override
    public boolean hasCandidates() {
        return false;
    }

    @Override
    public int getIgnoreBorder() {
        return 1;
    }

    @Override
    public boolean localMinimums() {
        return true;
    }

    @Override
    public boolean localMaximums() {
        return true;
    }
}

