/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.DdaFeatureManager;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class DetectDescribeAssociate<I extends ImageGray<I>, Desc extends TupleDesc>
implements PointTracker<I> {
    protected AssociateDescription2D<Desc> associate;
    protected DdaFeatureManager<I, Desc> manager;
    protected SetTrackInfo<Desc>[] sets;
    protected List<PointTrack> tracksAll = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksActive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksInactive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksDropped = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksNew = new ArrayList<PointTrack>();
    protected List<PointTrack> unused = new ArrayList<PointTrack>();
    protected long frameID = -1L;
    protected long featureID = 0L;
    boolean updateDescription;
    protected int maxInactiveTracks;
    protected GrowQueue_I32 unassociatedIdx = new GrowQueue_I32();
    protected Random rand;
    List<PointTrack> excessiveList = new ArrayList<PointTrack>();

    public DetectDescribeAssociate(DdaFeatureManager<I, Desc> manager, AssociateDescription2D<Desc> associate, ConfigTrackerDda config) {
        this.manager = manager;
        this.associate = associate;
        this.updateDescription = config.updateDescription;
        this.maxInactiveTracks = config.maxUnusedTracks;
        this.rand = new Random(config.seed);
        this.sets = new SetTrackInfo[manager.getNumberOfSets()];
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i] = new SetTrackInfo();
            this.sets[i].featSrc = new FastArray(manager.getDescriptionType());
            this.sets[i].featDst = new FastArray(manager.getDescriptionType());
        }
    }

    protected DetectDescribeAssociate() {
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }

    @Override
    public void reset() {
        this.dropAllTracks();
        this.featureID = 0L;
        this.frameID = -1L;
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].featDst.reset();
            this.sets[i].locDst.reset();
            this.sets[i].matches.reset();
        }
    }

    @Override
    public long getFrameID() {
        return this.frameID;
    }

    @Override
    public int getTotalActive() {
        return this.tracksActive.size();
    }

    @Override
    public int getTotalInactive() {
        return this.tracksInactive.size();
    }

    @Override
    public void process(I input) {
        ++this.frameID;
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.manager.detectFeatures(input);
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            int j;
            SetTrackInfo<Desc> info = this.sets[setIndex];
            info.featDst.reset();
            info.locDst.reset();
            this.manager.getFeatures(setIndex, info.locDst, info.featDst);
            if (info.tracks.isEmpty()) continue;
            this.performTracking(info);
            this.unassociatedIdx.reset();
            for (j = 0; j < info.tracks.size(); ++j) {
                if (info.isAssociated[j]) continue;
                this.unassociatedIdx.add(j);
                this.tracksInactive.add(info.tracks.get(j));
            }
            this.pruneExcessiveInactiveTracks(info, this.unassociatedIdx);
            for (j = 0; j < this.sets.length; ++j) {
                this.sets[j].featSrc.reset();
                this.sets[j].locSrc.reset();
            }
        }
    }

    private void pruneExcessiveInactiveTracks(SetTrackInfo<Desc> info, GrowQueue_I32 unassociated) {
        if (unassociated.size > this.maxInactiveTracks) {
            int i;
            int numDrop = unassociated.size - this.maxInactiveTracks;
            for (i = 0; i < numDrop; ++i) {
                int selected = this.rand.nextInt(unassociated.size - i) + i;
                int a = unassociated.get(i);
                unassociated.data[i] = unassociated.data[selected];
                unassociated.data[selected] = a;
            }
            this.excessiveList.clear();
            for (i = 0; i < numDrop; ++i) {
                this.excessiveList.add(info.tracks.get(unassociated.get(i)));
            }
            for (i = 0; i < this.excessiveList.size(); ++i) {
                this.tracksDropped.add(this.excessiveList.get(i));
                this.dropTrack(this.excessiveList.get(i));
            }
        }
    }

    protected void performTracking(SetTrackInfo<Desc> info) {
        this.putIntoSrcList(info);
        this.associate.setSource((FastAccess<Point2D_F64>)info.locSrc, info.featSrc);
        this.associate.setDestination((FastAccess<Point2D_F64>)info.locDst, info.featDst);
        this.associate.associate();
        FastAccess<AssociatedIndex> matches = this.associate.getMatches();
        info.matches.resize(matches.size);
        for (int i = 0; i < matches.size; ++i) {
            ((AssociatedIndex)info.matches.get(i)).set((AssociatedIndex)matches.get(i));
        }
        this.updateTrackState(info);
    }

    protected void putIntoSrcList(SetTrackInfo<Desc> info) {
        if (info.isAssociated.length < info.tracks.size()) {
            info.isAssociated = new boolean[info.tracks.size()];
        }
        info.featSrc.reset();
        info.locSrc.reset();
        for (int i = 0; i < info.tracks.size(); ++i) {
            PointTrack t = info.tracks.get(i);
            TupleDesc desc = (TupleDesc)t.getDescription();
            info.featSrc.add((Object)desc);
            info.locSrc.add((Object)t.pixel);
            info.isAssociated[i] = false;
        }
    }

    protected void updateTrackState(SetTrackInfo<Desc> info) {
        for (int i = 0; i < info.matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])info.matches.data)[i];
            PointTrack track = info.tracks.get(indexes.src);
            Point2D_F64 loc = ((Point2D_F64[])info.locDst.data)[indexes.dst];
            track.pixel.set(loc.x, loc.y);
            this.tracksActive.add(track);
            if (this.updateDescription) {
                ((TupleDesc)track.getDescription()).setTo((TupleDesc)info.featDst.get(indexes.dst));
            }
            info.isAssociated[indexes.src] = true;
        }
    }

    @Override
    public void spawnTracks() {
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            int i;
            SetTrackInfo<Desc> info = this.sets[setIndex];
            if (info.isAssociated.length < info.featDst.size) {
                info.isAssociated = new boolean[info.featDst.size];
            }
            for (i = 0; i < info.featDst.size; ++i) {
                info.isAssociated[i] = false;
            }
            for (i = 0; i < info.matches.size; ++i) {
                info.isAssociated[((AssociatedIndex[])info.matches.data)[i].dst] = true;
            }
            for (i = 0; i < info.featDst.size; ++i) {
                if (info.isAssociated[i]) continue;
                Point2D_F64 loc = (Point2D_F64)info.locDst.get(i);
                this.addNewTrack(setIndex, loc.x, loc.y, (TupleDesc)info.featDst.get(i));
            }
        }
    }

    protected PointTrack addNewTrack(int setIndex, double x, double y, Desc desc) {
        PointTrack p = this.getUnused();
        p.pixel.set(x, y);
        ((TupleDesc)p.getDescription()).setTo(desc);
        if (this.checkValidSpawn(setIndex, p)) {
            p.spawnFrameID = this.frameID;
            p.setId = setIndex;
            p.featureId = this.featureID++;
            this.sets[setIndex].tracks.add(p);
            this.tracksNew.add(p);
            this.tracksActive.add(p);
            this.tracksAll.add(p);
            return p;
        }
        this.unused.add(p);
        return null;
    }

    protected boolean checkValidSpawn(int setIndex, PointTrack p) {
        return true;
    }

    protected PointTrack getUnused() {
        PointTrack p;
        if (this.unused.size() > 0) {
            p = this.unused.remove(this.unused.size() - 1);
        } else {
            p = new PointTrack();
            p.setDescription(this.manager.createDescription());
        }
        return p;
    }

    @Override
    public void dropAllTracks() {
        this.unused.addAll(this.tracksAll);
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksAll.clear();
        this.tracksNew.clear();
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            SetTrackInfo<Desc> info = this.sets[setIndex];
            info.tracks.clear();
        }
    }

    @Override
    public int getMaxSpawn() {
        return 0;
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (!this.tracksAll.remove(track)) {
            return false;
        }
        if (!this.sets[track.setId].tracks.remove(track)) {
            throw new RuntimeException("Not in set!?!");
        }
        this.tracksActive.remove(track);
        this.tracksInactive.remove(track);
        this.unused.add(track);
        return true;
    }

    @Override
    public void dropTracks(PointTracker.Dropper dropper) {
        for (int i = this.tracksAll.size() - 1; i >= 0; --i) {
            PointTrack track = this.tracksAll.get(i);
            if (!dropper.shouldDropTrack(track)) continue;
            if (!this.sets[track.setId].tracks.remove(track)) {
                throw new RuntimeException("BUG! Not in set!?!");
            }
            this.tracksAll.remove(i);
            this.tracksActive.remove(track);
            this.tracksInactive.remove(track);
            this.unused.add(track);
        }
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        } else {
            list.clear();
        }
        list.addAll(this.tracksActive);
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        } else {
            list.clear();
        }
        list.addAll(this.tracksDropped);
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksNew);
        return list;
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        } else {
            list.clear();
        }
        list.addAll(this.tracksAll);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        } else {
            list.clear();
        }
        list.addAll(this.tracksInactive);
        return list;
    }

    protected static class SetTrackInfo<Desc> {
        protected FastArray<Point2D_F64> locDst = new FastArray(Point2D_F64.class);
        protected FastArray<Point2D_F64> locSrc = new FastArray(Point2D_F64.class);
        protected FastArray<Desc> featSrc;
        protected FastArray<Desc> featDst;
        protected boolean[] isAssociated = new boolean[1];
        protected List<PointTrack> tracks = new ArrayList<PointTrack>();
        protected FastQueue<AssociatedIndex> matches = new FastQueue(AssociatedIndex::new);

        protected SetTrackInfo() {
        }
    }
}

