/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class PointTrack {
    public final Point2D_F64 pixel = new Point2D_F64();
    public int setId;
    public long featureId;
    public Object cookie;
    public long spawnFrameID;
    private Object description;

    public PointTrack(double x, double y, long featureId) {
        this.pixel.set(x, y);
        this.featureId = featureId;
    }

    public PointTrack() {
    }

    public static List<Point2D_F64> extractTrackPixels(@Nullable List<Point2D_F64> storage, List<PointTrack> tracks) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F64>();
        } else {
            storage.clear();
        }
        for (int i = 0; i < tracks.size(); ++i) {
            storage.add(tracks.get((int)i).pixel);
        }
        return storage;
    }

    public void set(PointTrack t) {
        this.featureId = t.featureId;
        this.spawnFrameID = t.spawnFrameID;
        this.pixel.set(t.pixel);
        this.cookie = t.cookie;
        this.description = t.description;
    }

    public void reset() {
        this.spawnFrameID = -1L;
        this.featureId = -1L;
        this.cookie = null;
        this.description = null;
    }

    public <T> T getCookie() {
        return (T)this.cookie;
    }

    public <T> T getDescription() {
        return (T)this.description;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public void setCookie(Object cookie) {
        this.cookie = cookie;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

