/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.derivative.DerivativeReduceType;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;

public abstract class BaseDenseHog<I extends ImageBase<I>> {
    ImageGradient<I, GrayF32> gradient;
    protected GrayF32 derivX = new GrayF32(1, 1);
    protected GrayF32 derivY = new GrayF32(1, 1);
    FastQueue<TupleDesc_F64> descriptions;
    FastQueue<Point2D_I32> locations = new FastQueue(Point2D_I32::new);
    int orientationBins;
    int pixelsPerCell;
    int cellsPerBlockX;
    int cellsPerBlockY;
    int stepBlock;
    ImageType<I> imageType;

    public BaseDenseHog(int orientationBins, int pixelsPerCell, int cellsPerBlockX, int cellsPerBlockY, int stepBlock, ImageType<I> imageType) {
        if (stepBlock <= 0) {
            throw new IllegalArgumentException("stepBlock must be >= 1");
        }
        this.imageType = imageType;
        this.gradient = BaseDenseHog.createGradient(imageType);
        this.orientationBins = orientationBins;
        this.pixelsPerCell = pixelsPerCell;
        this.cellsPerBlockX = cellsPerBlockX;
        this.cellsPerBlockY = cellsPerBlockY;
        this.stepBlock = stepBlock;
        int descriptorLength = orientationBins * cellsPerBlockX * cellsPerBlockY;
        this.descriptions = new FastQueue(() -> new TupleDesc_F64(descriptorLength));
    }

    static <Input extends ImageBase<Input>> ImageGradient<Input, GrayF32> createGradient(ImageType<Input> imageType) {
        ImageGradient gradient;
        ImageType typeF32 = ImageType.SB_F32;
        if (imageType.getDataType() != ImageDataType.F32) {
            throw new IllegalArgumentException("Input image type must be F32");
        }
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            gradient = FactoryDerivative.gradient((DerivativeType)DerivativeType.THREE, imageType, (ImageType)typeF32);
        } else if (imageType.getFamily() == ImageType.Family.PLANAR) {
            ImageType typePF32 = ImageType.pl((int)imageType.getNumBands(), GrayF32.class);
            ImageGradient gradientMB = FactoryDerivative.gradient((DerivativeType)DerivativeType.THREE, (ImageType)typePF32, (ImageType)typePF32);
            gradient = FactoryDerivative.gradientReduce((ImageGradient)gradientMB, (DerivativeReduceType)DerivativeReduceType.MAX_F, GrayF32.class);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + imageType);
        }
        return gradient;
    }

    public void setInput(I input) {
        this.derivX.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.derivY.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.gradient.process(input, (ImageBase)this.derivX, (ImageBase)this.derivY);
    }

    public abstract void process();

    public FastQueue<Point2D_I32> getLocations() {
        return this.locations;
    }

    public FastQueue<TupleDesc_F64> getDescriptions() {
        return this.descriptions;
    }

    public GrayF32 _getDerivX() {
        return this.derivX;
    }

    public GrayF32 _getDerivY() {
        return this.derivY;
    }

    public int getRegionWidthPixelX() {
        return this.pixelsPerCell * this.cellsPerBlockX;
    }

    public int getRegionWidthPixelY() {
        return this.pixelsPerCell * this.cellsPerBlockY;
    }

    public int getPixelsPerCell() {
        return this.pixelsPerCell;
    }

    public int getCellsPerBlockX() {
        return this.cellsPerBlockX;
    }

    public int getCellsPerBlockY() {
        return this.cellsPerBlockY;
    }

    public int getStepBlock() {
        return this.stepBlock;
    }

    public int getOrientationBins() {
        return this.orientationBins;
    }

    public ImageType<I> getImageType() {
        return this.imageType;
    }

    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.orientationBins * this.cellsPerBlockX * this.cellsPerBlockY);
    }
}

