/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;

public class HysteresisEdgeTraceMark {
    public static final float MARK_TRAVERSED = -1.0f;
    private GrayF32 intensity;
    private GrayS8 direction;
    private GrayU8 output;
    private float lower;
    private FastQueue<Point2D_I32> open = new FastQueue(Point2D_I32::new);
    private Point2D_I32 active = new Point2D_I32();

    public void process(GrayF32 intensity, GrayS8 direction, float lower, float upper, GrayU8 output) {
        if (lower < 0.0f) {
            throw new IllegalArgumentException("Lower must be >= 0!");
        }
        InputSanityCheck.checkSameShape((ImageBase)intensity, (ImageBase)direction, (ImageBase)output);
        this.intensity = intensity;
        this.direction = direction;
        this.output = output;
        this.lower = lower;
        ImageMiscOps.fill((GrayI8)output, (int)0);
        for (int y = 0; y < intensity.height; ++y) {
            int indexInten = intensity.startIndex + y * intensity.stride;
            int x = 0;
            while (x < intensity.width) {
                if (intensity.data[indexInten] >= upper) {
                    this.trace(x, y, indexInten);
                }
                ++x;
                ++indexInten;
            }
        }
    }

    protected void trace(int x, int y, int indexInten) {
        int indexOut = this.output.getIndex(x, y);
        ((Point2D_I32)this.open.grow()).set(x, y);
        this.output.data[indexOut] = 1;
        this.intensity.data[indexInten] = -1.0f;
        block6: while (this.open.size() > 0) {
            this.active.set((Point2D_I32)this.open.removeTail());
            indexInten = this.intensity.getIndex(this.active.x, this.active.y);
            int indexDir = this.direction.getIndex(this.active.x, this.active.y);
            boolean first = true;
            while (true) {
                int dy;
                int dx;
                switch (this.direction.data[indexDir]) {
                    case 0: {
                        dx = 0;
                        dy = 1;
                        break;
                    }
                    case 1: {
                        dx = 1;
                        dy = -1;
                        break;
                    }
                    case 2: {
                        dx = 1;
                        dy = 0;
                        break;
                    }
                    case -1: {
                        dx = 1;
                        dy = 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown direction: " + this.direction.data[indexDir]);
                    }
                }
                int indexForward = indexInten + dy * this.intensity.stride + dx;
                int indexBackward = indexInten - dy * this.intensity.stride - dx;
                int prevIndexDir = indexDir;
                boolean match = false;
                x = this.active.x;
                y = this.active.y;
                int fx = this.active.x + dx;
                int fy = this.active.y + dy;
                int bx = this.active.x - dx;
                int by = this.active.y - dy;
                if (this.intensity.isInBounds(fx, fy) && this.intensity.data[indexForward] >= this.lower) {
                    this.intensity.data[indexForward] = -1.0f;
                    this.output.unsafe_set(fx, fy, 1);
                    this.active.set(fx, fy);
                    match = true;
                    indexInten = indexForward;
                    indexDir = prevIndexDir + dy * this.intensity.stride + dx;
                }
                if (this.intensity.isInBounds(bx, by) && this.intensity.data[indexBackward] >= this.lower) {
                    this.intensity.data[indexBackward] = -1.0f;
                    this.output.unsafe_set(bx, by, 1);
                    if (match) {
                        ((Point2D_I32)this.open.grow()).set(bx, by);
                    } else {
                        this.active.set(bx, by);
                        match = true;
                        indexInten = indexBackward;
                        indexDir = prevIndexDir - dy * this.intensity.stride - dx;
                    }
                }
                if (!first && match) continue;
                boolean priorMatch = match;
                if (!(match = this.checkAllNeighbors(x, y, match))) continue block6;
                first = false;
                if (priorMatch) continue;
                indexInten = this.intensity.getIndex(this.active.x, this.active.y);
                indexDir = this.direction.getIndex(this.active.x, this.active.y);
            }
        }
    }

    private boolean checkAllNeighbors(int x, int y, boolean match) {
        match |= this.check(x + 1, y, match);
        match |= this.check(x, y + 1, match);
        match |= this.check(x - 1, y, match);
        match |= this.check(x, y - 1, match);
        match |= this.check(x + 1, y + 1, match);
        match |= this.check(x + 1, y - 1, match);
        match |= this.check(x - 1, y + 1, match);
        match |= this.check(x - 1, y - 1, match);
        return match;
    }

    private boolean check(int x, int y, boolean match) {
        int index;
        if (this.intensity.isInBounds(x, y) && this.intensity.data[index = this.intensity.getIndex(x, y)] >= this.lower) {
            this.intensity.data[index] = -1.0f;
            this.output.unsafe_set(x, y, 1);
            if (match) {
                ((Point2D_I32)this.open.grow()).set(x, y);
            } else {
                this.active.set(x, y);
            }
            return true;
        }
        return false;
    }
}

