/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxCandidate;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;

public class NonMaxCandidate_MT
extends NonMaxCandidate {
    final FastQueue<SearchData> searches = new FastQueue(this::createSearchData);

    public NonMaxCandidate_MT(NonMaxCandidate.Search search) {
        super(search);
    }

    @Override
    protected void examineMinimum(GrayF32 intensityImage, FastAccess<Point2D_I16> candidates, FastQueue<Point2D_I16> found) {
        found.reset();
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks((int)0, (int)candidates.size, this.searches, (blockData, idx0, idx1) -> {
            QueueCorner threadCorners = blockData.corners;
            NonMaxCandidate.Search search = blockData.search;
            threadCorners.reset();
            search.initialize(intensityImage);
            for (int iter = idx0; iter < idx1; ++iter) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val;
                Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) > this.thresholdMin || val == -3.4028235E38f || !search.searchMin(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val)) continue;
                threadCorners.append((int)pt.x, (int)pt.y);
            }
        });
        for (int i = 0; i < this.searches.size; ++i) {
            found.copyAll(((SearchData)this.searches.get((int)i)).corners.toList(), (src, dst) -> dst.set(src));
        }
    }

    @Override
    protected void examineMaximum(GrayF32 intensityImage, FastAccess<Point2D_I16> candidates, FastQueue<Point2D_I16> found) {
        found.reset();
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks((int)0, (int)candidates.size, this.searches, (blockData, idx0, idx1) -> {
            QueueCorner threadCorners = blockData.corners;
            NonMaxCandidate.Search search = blockData.search;
            threadCorners.reset();
            search.initialize(intensityImage);
            for (int iter = idx0; iter < idx1; ++iter) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val;
                Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) < this.thresholdMax || val == Float.MAX_VALUE || !search.searchMax(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val)) continue;
                threadCorners.append((int)pt.x, (int)pt.y);
            }
        });
        for (int i = 0; i < this.searches.size; ++i) {
            found.copyAll(((SearchData)this.searches.get((int)i)).corners.toList(), (src, dst) -> dst.set(src));
        }
    }

    public SearchData createSearchData() {
        return new SearchData(this.search.newInstance());
    }

    protected static class SearchData {
        public final NonMaxCandidate.Search search;
        public final QueueCorner corners = new QueueCorner();

        public SearchData(NonMaxCandidate.Search search) {
            this.search = search;
        }
    }
}

