/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class ImplSsdCornerNaive<T extends ImageGray<T>>
implements GradientCornerIntensity<T> {
    private int radius;
    private Kernel2D_S32 weights;

    public ImplSsdCornerNaive(int imageWidth, int imageHeight, int windowRadius, boolean weighted) {
        this.radius = windowRadius;
        if (weighted) {
            this.weights = (Kernel2D_S32)FactoryKernelGaussian.gaussian(Kernel2D_S32.class, (double)-1.0, (int)this.radius);
        }
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return this.radius;
    }

    @Override
    public void process(T derivX, T derivY, GrayF32 intensity) {
        int imgHeight = derivX.getHeight();
        int imgWidth = derivX.getWidth();
        for (int row = this.radius; row < imgHeight - this.radius; ++row) {
            for (int col = this.radius; col < imgWidth - this.radius; ++col) {
                double dxdx = 0.0;
                double dxdy = 0.0;
                double dydy = 0.0;
                double totalW = 0.0;
                for (int i = -this.radius; i <= this.radius; ++i) {
                    for (int j = -this.radius; j <= this.radius; ++j) {
                        double dx = GeneralizedImageOps.get(derivX, (int)(col + j), (int)(row + i));
                        double dy = GeneralizedImageOps.get(derivY, (int)(col + j), (int)(row + i));
                        double w = 1.0;
                        if (this.weights != null) {
                            w = this.weights.get(j + this.radius, i + this.radius);
                        }
                        dxdx += w * dx * dx;
                        dydy += w * dy * dy;
                        dxdy += w * dx * dy;
                        totalW += w;
                    }
                }
                if (this.weights != null) {
                    dxdx /= totalW;
                    dydy /= totalW;
                    dxdy /= totalW;
                }
                double left = (dxdx + dydy) * 0.5;
                double b = (dxdx - dydy) * 0.5;
                double right = Math.sqrt(b * b + dxdy * dxdy);
                intensity.set(col, row, (float)(left - right));
            }
        }
    }

    @Override
    public Class<T> getInputType() {
        return null;
    }
}

