/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBox;
import boofcv.concurrency.FWorkArrays;
import boofcv.struct.image.GrayF32;

public class ImplSsdCorner_F32
extends ImplSsdCornerBox<GrayF32, GrayF32> {
    private FWorkArrays work = new FWorkArrays();
    private ImplSsdCornerBase.CornerIntensity_F32 intensity;

    public ImplSsdCorner_F32(int windowRadius, ImplSsdCornerBase.CornerIntensity_F32 intensity) {
        super(windowRadius, GrayF32.class, GrayF32.class);
        this.intensity = intensity;
    }

    @Override
    protected void setImageShape(int imageWidth, int imageHeight) {
        super.setImageShape(imageWidth, imageHeight);
        this.work.reset(imageWidth);
    }

    @Override
    protected void horizontal() {
        float[] dataX = ((GrayF32)this.derivX).data;
        float[] dataY = ((GrayF32)this.derivY).data;
        float[] hXX = ((GrayF32)this.horizXX).data;
        float[] hXY = ((GrayF32)this.horizXY).data;
        float[] hYY = ((GrayF32)this.horizYY).data;
        int imgHeight = ((GrayF32)this.derivX).getHeight();
        int imgWidth = ((GrayF32)this.derivX).getWidth();
        int windowWidth = this.radius * 2 + 1;
        int radp1 = this.radius + 1;
        for (int row = 0; row < imgHeight; ++row) {
            float dy;
            float dx;
            int pix;
            int end = pix + windowWidth;
            float totalXX = 0.0f;
            float totalXY = 0.0f;
            float totalYY = 0.0f;
            int indexX = ((GrayF32)this.derivX).startIndex + row * ((GrayF32)this.derivX).stride;
            int indexY = ((GrayF32)this.derivY).startIndex + row * ((GrayF32)this.derivY).stride;
            for (pix = row * imgWidth; pix < end; ++pix) {
                dx = dataX[indexX++];
                dy = dataY[indexY++];
                totalXX += dx * dx;
                totalXY += dx * dy;
                totalYY += dy * dy;
            }
            hXX[pix - radp1] = totalXX;
            hXY[pix - radp1] = totalXY;
            hYY[pix - radp1] = totalYY;
            end = row * imgWidth + imgWidth;
            while (pix < end) {
                dx = dataX[indexX - windowWidth];
                dy = dataY[indexY - windowWidth];
                totalXX -= dx * dx;
                totalXY -= dx * dy;
                totalYY -= dy * dy;
                dx = dataX[indexX];
                dy = dataY[indexY];
                hXX[pix - this.radius] = totalXX += dx * dx;
                hXY[pix - this.radius] = totalXY += dx * dy;
                hYY[pix - this.radius] = totalYY += dy * dy;
                ++pix;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void vertical(GrayF32 intensity) {
        int srcIndex;
        int destIndex;
        float[] hXX = ((GrayF32)this.horizXX).data;
        float[] hXY = ((GrayF32)this.horizXY).data;
        float[] hYY = ((GrayF32)this.horizYY).data;
        float[] inten = intensity.data;
        int imgHeight = ((GrayF32)this.horizXX).getHeight();
        int imgWidth = ((GrayF32)this.horizXX).getWidth();
        int kernelWidth = this.radius * 2 + 1;
        int startX = this.radius;
        int endX = imgWidth - this.radius;
        int backStep = kernelWidth * imgWidth;
        int y0 = this.radius;
        int y1 = imgHeight - this.radius;
        float[] tempXX = this.work.pop();
        float[] tempXY = this.work.pop();
        float[] tempYY = this.work.pop();
        for (int x = startX; x < endX; ++x) {
            destIndex = imgWidth * y0 + x;
            float totalXX = 0.0f;
            float totalXY = 0.0f;
            float totalYY = 0.0f;
            int indexEnd = srcIndex + imgWidth * kernelWidth;
            for (srcIndex = x + (y0 - this.radius) * imgWidth; srcIndex < indexEnd; srcIndex += imgWidth) {
                totalXX += hXX[srcIndex];
                totalXY += hXY[srcIndex];
                totalYY += hYY[srcIndex];
            }
            tempXX[x] = totalXX;
            tempXY[x] = totalXY;
            tempYY[x] = totalYY;
            inten[destIndex] = this.intensity.compute(totalXX, totalXY, totalYY);
            destIndex += imgWidth;
        }
        for (int y = y0 + 1; y < y1; ++y) {
            srcIndex = (y + this.radius) * imgWidth + startX;
            destIndex = y * imgWidth + startX;
            int x = startX;
            while (x < endX) {
                float totalXX = tempXX[x] - hXX[srcIndex - backStep];
                tempXX[x] = totalXX += hXX[srcIndex];
                float totalXY = tempXY[x] - hXY[srcIndex - backStep];
                tempXY[x] = totalXY += hXY[srcIndex];
                float totalYY = tempYY[x] - hYY[srcIndex - backStep];
                tempYY[x] = totalYY += hYY[srcIndex];
                inten[destIndex] = this.intensity.compute(totalXX, totalXY, totalYY);
                ++x;
                ++srcIndex;
                ++destIndex;
            }
        }
        this.work.recycle(tempXX);
        this.work.recycle(tempXY);
        this.work.recycle(tempYY);
    }
}

