/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.peak;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.weights.WeightPixel_F32;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;

public class MeanShiftPeak<T extends ImageGray<T>> {
    protected T image;
    protected InterpolatePixelS<T> interpolate;
    protected int maxIterations;
    protected int radius;
    protected int width;
    protected float convergenceTol;
    protected float peakX;
    protected float peakY;
    protected boolean odd;
    protected WeightPixel_F32 weights;

    public MeanShiftPeak(int maxIterations, float convergenceTol, WeightPixel_F32 weights, boolean odd, Class<T> imageType, BorderType borderType) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.odd = odd;
        this.weights = weights;
        this.interpolate = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)borderType);
    }

    public void setImage(T image) {
        this.image = image;
        this.interpolate.setImage(image);
    }

    public void setRadius(int radius) {
        this.weights.setRadius(radius, radius, this.odd);
        this.radius = radius;
        this.width = this.odd ? radius * 2 + 1 : radius * 2;
    }

    public void search(float cx, float cy) {
        this.peakX = cx;
        this.peakY = cy;
        if (this.radius <= 0) {
            return;
        }
        float offset = (float)(-this.radius) + (this.weights.isOdd() ? 0.0f : 0.5f);
        for (int i = 0; i < this.maxIterations; ++i) {
            float weight;
            float w;
            float x;
            int xx;
            float y;
            int yy;
            float total = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            int kernelIndex = 0;
            if (this.interpolate.isInFastBounds(this.peakX + offset, this.peakY + offset) && this.interpolate.isInFastBounds(this.peakX - offset, this.peakY - offset)) {
                for (yy = 0; yy < this.width; ++yy) {
                    y = offset + (float)yy;
                    for (xx = 0; xx < this.width; ++xx) {
                        x = offset + (float)xx;
                        w = this.weights.weightIndex(kernelIndex++);
                        weight = w * this.interpolate.get_fast(this.peakX + x, this.peakY + y);
                        total += weight;
                        sumX += weight * x;
                        sumY += weight * y;
                    }
                }
            } else {
                for (yy = 0; yy < this.width; ++yy) {
                    y = offset + (float)yy;
                    for (xx = 0; xx < this.width; ++xx) {
                        x = offset + (float)xx;
                        w = this.weights.weightIndex(kernelIndex++);
                        weight = w * this.interpolate.get(this.peakX + x, this.peakY + y);
                        total += weight;
                        sumX += weight * x;
                        sumY += weight * y;
                    }
                }
            }
            if (total == 0.0f) break;
            cx = this.peakX + sumX / total;
            cy = this.peakY + sumY / total;
            float dx = cx - this.peakX;
            float dy = cy - this.peakY;
            this.peakX = cx;
            this.peakY = cy;
            if (Math.abs(dx) < this.convergenceTol && Math.abs(dy) < this.convergenceTol) break;
        }
    }

    public void searchPositive(float cx, float cy) {
        this.peakX = cx;
        this.peakY = cy;
        if (this.radius <= 0) {
            return;
        }
        float offset = (float)(-this.radius) + (this.weights.isOdd() ? 0.0f : 0.5f);
        for (int i = 0; i < this.maxIterations; ++i) {
            float weight;
            float w;
            float x;
            int xx;
            float y;
            int yy;
            float total = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            int kernelIndex = 0;
            if (this.interpolate.isInFastBounds(this.peakX + offset, this.peakY + offset) && this.interpolate.isInFastBounds(this.peakX - offset, this.peakY - offset)) {
                for (yy = 0; yy < this.width; ++yy) {
                    y = offset + (float)yy;
                    for (xx = 0; xx < this.width; ++xx) {
                        x = offset + (float)xx;
                        int n = kernelIndex++;
                        w = this.weights.weightIndex(n);
                        weight = w * this.interpolate.get_fast(this.peakX + x, this.peakY + y);
                        if (!(weight > 0.0f)) continue;
                        total += weight;
                        sumX += weight * x;
                        sumY += weight * y;
                    }
                }
            } else {
                for (yy = 0; yy < this.width; ++yy) {
                    y = offset + (float)yy;
                    for (xx = 0; xx < this.width; ++xx) {
                        x = offset + (float)xx;
                        int n = kernelIndex++;
                        w = this.weights.weightIndex(n);
                        weight = w * this.interpolate.get(this.peakX + x, this.peakY + y);
                        if (!(weight > 0.0f)) continue;
                        total += weight;
                        sumX += weight * x;
                        sumY += weight * y;
                    }
                }
            }
            if (total == 0.0f) break;
            cx = this.peakX + sumX / total;
            cy = this.peakY + sumY / total;
            float dx = cx - this.peakX;
            float dy = cy - this.peakY;
            this.peakX = cx;
            this.peakY = cy;
            if (Math.abs(dx) < this.convergenceTol && Math.abs(dy) < this.convergenceTol) break;
        }
    }

    public float getPeakX() {
        return this.peakX;
    }

    public float getPeakY() {
        return this.peakY;
    }

    public int getRadius() {
        return this.radius;
    }

    public InterpolatePixelS<T> getInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(InterpolatePixelS<T> interpolate) {
        this.interpolate = interpolate;
    }

    public boolean isOdd() {
        return this.odd;
    }
}

