/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.border.GrowBorder;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public abstract class DisparityBlockMatchRowFormat<Input extends ImageBase<Input>, Disparity extends ImageGray<Disparity>> {
    protected int disparityMin;
    protected int disparityMax;
    protected int disparityRange;
    protected int widthDisparityBlock;
    protected int radiusX;
    protected int radiusY;
    protected int regionWidth;
    protected int regionHeight;
    protected GrowBorder<Input, Object> growBorderL;
    protected GrowBorder<Input, Object> growBorderR;

    public DisparityBlockMatchRowFormat(int regionRadiusX, int regionRadiusY, ImageType<Input> imageType) {
        this.radiusX = regionRadiusX;
        this.radiusY = regionRadiusY;
        this.regionWidth = regionRadiusX * 2 + 1;
        this.regionHeight = regionRadiusY * 2 + 1;
        this.growBorderL = FactoryImageBorder.createGrowBorder(imageType);
        this.growBorderR = FactoryImageBorder.createGrowBorder(imageType);
    }

    public void setBorder(ImageBorder<Input> border) {
        this.growBorderL.setBorder(border.copy());
        this.growBorderR.setBorder(border.copy());
    }

    public void configure(int disparityMin, int disparityRange) {
        if (disparityMin < 0) {
            throw new IllegalArgumentException("Min disparity must be greater than or equal to zero. max=" + disparityMin);
        }
        if (disparityRange <= 0) {
            throw new IllegalArgumentException("Disparity range must be more than 0");
        }
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
        this.disparityMax = disparityMin + disparityRange - 1;
    }

    public void process(Input left, Input right, Disparity disparity) {
        InputSanityCheck.checkSameShape(left, right);
        if (this.disparityMax > ((ImageBase)left).width) {
            throw new RuntimeException("The maximum disparity is too large for this image size: max size " + ((ImageBase)left).width);
        }
        this.widthDisparityBlock = ((ImageBase)left).width * this.disparityRange;
        this._process(left, right, disparity);
    }

    public abstract void _process(Input var1, Input var2, Disparity var3);

    public abstract ImageType<Input> getInputType();

    public abstract Class<Disparity> getDisparityType();

    public int getBorderX() {
        return 0;
    }

    public int getBorderY() {
        return this.radiusY;
    }

    public int getMaxRegionError() {
        return this.regionWidth * this.regionHeight * this.getMaxPerPixelError();
    }

    protected abstract int getMaxPerPixelError();

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public int getDisparityMax() {
        return this.disparityMax;
    }

    public int getDisparityRange() {
        return this.disparityRange;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }

    public GrowBorder<Input, Object> getGrowBorderL() {
        return this.growBorderL;
    }

    public GrowBorder<Input, Object> getGrowBorderR() {
        return this.growBorderR;
    }
}

