/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.score;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageGray;

public abstract class DisparitySparseRectifiedScoreBM<ArrayData, Input extends ImageGray<Input>> {
    protected int disparityMin;
    protected int disparityMax;
    protected int disparityRange;
    protected int localRangeLtoR;
    protected int localRangeRtoL;
    protected int radiusX;
    protected int radiusY;
    protected int blockWidth;
    protected int blockHeight;
    protected int sampledWidth;
    protected int sampledHeight;
    protected Input left;
    protected Input right;
    protected ImageBorder<Input> border;
    protected Class<Input> inputType;
    protected final Input patchTemplate;
    protected final Input patchCompare;
    protected int sampleRadiusX = -1;
    protected int sampleRadiusY = -1;

    public DisparitySparseRectifiedScoreBM(int radiusX, int radiusY, Class<Input> inputType) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.blockWidth = radiusX * 2 + 1;
        this.blockHeight = radiusY * 2 + 1;
        this.inputType = inputType;
        this.patchTemplate = GeneralizedImageOps.createSingleBand(inputType, (int)1, (int)1);
        this.patchCompare = GeneralizedImageOps.createSingleBand(inputType, (int)1, (int)1);
    }

    protected DisparitySparseRectifiedScoreBM(Class<Input> inputType) {
        this.inputType = inputType;
        this.patchTemplate = GeneralizedImageOps.createSingleBand(inputType, (int)1, (int)1);
        this.patchCompare = GeneralizedImageOps.createSingleBand(inputType, (int)1, (int)1);
    }

    protected void setSampleRegion(int radiusX, int radiusY) {
        this.sampleRadiusX = radiusX;
        this.sampleRadiusY = radiusY;
    }

    public void setBorder(ImageBorder<Input> border) {
        this.border = border;
    }

    public void configure(int disparityMin, int disparityRange) {
        if (disparityMin < 0) {
            throw new IllegalArgumentException("Min disparity must be greater than or equal to zero. max=" + disparityMin);
        }
        if (disparityRange <= 0) {
            throw new IllegalArgumentException("Disparity range must be more than 0");
        }
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
        this.disparityMax = disparityMin + disparityRange - 1;
        if (this.sampleRadiusX < 0 || this.sampleRadiusY < 0) {
            throw new RuntimeException("Didn't set the sample radius");
        }
        this.sampledWidth = 2 * (this.sampleRadiusX + this.radiusX) + 1;
        this.sampledHeight = 2 * (this.sampleRadiusY + this.radiusY) + 1;
        this.patchTemplate.reshape(this.sampledWidth, this.sampledHeight);
    }

    public void setImages(Input left, Input right) {
        InputSanityCheck.checkSameShape(left, right);
        this.left = left;
        this.right = right;
    }

    public boolean processLeftToRight(int x, int y) {
        if (x < this.disparityMin) {
            return false;
        }
        this.localRangeLtoR = Math.min(x, this.disparityMax) - this.disparityMin + 1;
        this.patchCompare.reshape(this.sampledWidth + this.localRangeLtoR - 1, this.sampledHeight);
        this.copy(x, y, 1, this.left, this.patchTemplate);
        this.copy(x - this.disparityMin - this.localRangeLtoR + 1, y, this.localRangeLtoR, this.right, this.patchCompare);
        this.scoreDisparity(this.localRangeLtoR, true);
        return true;
    }

    public boolean processRightToLeft(int x, int y) {
        if (x + this.disparityMin >= ((ImageGray)this.left).width) {
            return false;
        }
        this.localRangeRtoL = Math.min(x + this.disparityMin + this.disparityRange, ((ImageGray)this.left).width) - x - this.disparityMin;
        this.patchCompare.reshape(this.sampledWidth + this.localRangeRtoL - 1, this.sampledHeight);
        this.copy(x, y, 1, this.right, this.patchTemplate);
        this.copy(x + this.disparityMin, y, this.localRangeRtoL, this.left, this.patchCompare);
        this.scoreDisparity(this.localRangeRtoL, false);
        return true;
    }

    protected final void copy(int startX, int startY, int length, Input src, Input dst) {
        int x0 = startX - this.radiusX - this.sampleRadiusX;
        int y0 = startY - this.radiusY - this.sampleRadiusY;
        int x1 = startX + this.radiusX + this.sampleRadiusX + length;
        int y1 = startY + this.radiusY + this.sampleRadiusY + 1;
        GImageMiscOps.copy((int)x0, (int)y0, (int)0, (int)0, (int)(x1 - x0), (int)(y1 - y0), src, this.border, dst);
    }

    protected abstract void scoreDisparity(int var1, boolean var2);

    public abstract ArrayData getScoreLtoR();

    public abstract ArrayData getScoreRtoL();

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public int getDisparityMax() {
        return this.disparityMax;
    }

    public int getDisparityRange() {
        return this.disparityRange;
    }

    public int getLocalRangeLtoR() {
        return this.localRangeLtoR;
    }

    public int getLocalRangeRtoL() {
        return this.localRangeRtoL;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public Class<Input> getInputType() {
        return this.inputType;
    }
}

